package com.bxm.newidea.cloud.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix = "biz")
@Component
public class PreProperties {

    /**
     * 是否启用预发环境，如果启用，在服务之间跳转时会判断是否只跳转到预发服务中
     * 定时任务等会自主发起服务请求的情况，通过此字段可防止访问到正式服务
     */
    private Boolean enablePreEnv;

    public Boolean getEnablePreEnv() {
        return enablePreEnv;
    }

    public void setEnablePreEnv(Boolean enablePreEnv) {
        this.enablePreEnv = enablePreEnv;
    }
}
