package com.bxm.newidea.cloud.config;

import com.bxm.newidea.cloud.ribbon.EnvDiscoveryEnabledRule;
import com.bxm.newidea.cloud.web.HttpHeaderHandlerInterceptorAdapter;
import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 注册web拦截器
 * @author liujia
 */
@Configuration
@ConditionalOnClass(DiscoveryEnabledNIWSServerList.class)
public class PreWebConfiguration implements WebMvcConfigurer {

    @Bean
    public HttpHeaderHandlerInterceptorAdapter interceptorAdapter() {
        return new HttpHeaderHandlerInterceptorAdapter();
    }

    @Bean
    public EnvDiscoveryEnabledRule envDiscoveryEnabledRule() {
        return new EnvDiscoveryEnabledRule();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(interceptorAdapter());
    }
}
