package com.bxm.newidea.cloud.web;

import com.bxm.newidea.cloud.constant.EnvConstant;
import com.bxm.newidea.cloud.ribbon.RibbonFilterContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 对请求进行前置拦截，将请求header记录到熔断器
 * @author liujia
 */
public class HttpHeaderHandlerInterceptorAdapter extends HandlerInterceptorAdapter {

    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHeaderHandlerInterceptorAdapter.class);

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String obj = request.getHeader(EnvConstant.ENV_HEADER_KEY);
        if (null != obj) {
            RibbonFilterContextHolder.getCurrentContext().add(EnvConstant.ENV_HEADER_KEY, EnvConstant.PRE_ENV_VALUE);
        }

        LOGGER.debug("request uri:" + request.getRequestURI(), "header:" + obj);

        return super.preHandle(request, response, handler);
    }
}
