/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.cloud.fegin;

import com.bxm.newidea.cloud.ribbon.RibbonFilterContextHolder;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.stereotype.Component;

@Component
public class HttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpRequestWrapper requestWrapper = new HttpRequestWrapper(request);
        String env = RibbonFilterContextHolder.getCurrentContext().get("env");
        if (null != env) {
            requestWrapper.getHeaders().add("env", "pre");
            RibbonFilterContextHolder.clearCurrentContext();
        }
        LOGGER.debug("request uri:" + request.getURI() + ",env: " + env);
        return execution.execute((HttpRequest)requestWrapper, body);
    }
}

