/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.preheat.config;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import com.bxm.component.preheat.properties.PreheatConfigurationProperties;
import com.bxm.component.preheat.registration.RegistrationNotify;
import com.bxm.newidea.component.core.PreheatPhaser;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class PreheatApplicationReadyListener
implements ApplicationListener<ApplicationReadyEvent>,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(PreheatApplicationReadyListener.class);
    private final List<PreheatPhaser> preheatPhaserList;
    private final List<RegistrationNotify> registrationNotifyList;
    private final PreheatConfigurationProperties properties;
    private ThreadPoolTaskExecutor executor;
    private final AtomicBoolean INIT_FLAG = new AtomicBoolean(false);

    public PreheatApplicationReadyListener(List<PreheatPhaser> preheatPhaserList, List<RegistrationNotify> registrationNotifyList, PreheatConfigurationProperties properties) {
        this.preheatPhaserList = preheatPhaserList;
        this.registrationNotifyList = registrationNotifyList;
        this.properties = properties;
        this.executor = new ThreadPoolTaskExecutor();
        this.executor.setCorePoolSize(Runtime.getRuntime().availableProcessors() * 2);
        this.executor.setThreadFactory((ThreadFactory)new NamedThreadFactory("preheat-phaser-execute"));
        this.executor.initialize();
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (!this.INIT_FLAG.compareAndSet(false, true)) {
            return;
        }
        if (CollectionUtil.isEmpty(this.preheatPhaserList)) {
            return;
        }
        ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
        String preheatEnabled = environment.getProperty("component.preheat.enabled", "true");
        if (!Boolean.parseBoolean(preheatEnabled)) {
            log.info("\u8bbe\u7f6e\u4e86{}\u4e3afalse\uff0c\u8df3\u8fc7\u9884\u70ed\u5904\u7406", (Object)"component.preheat.enabled");
            return;
        }
        TimeInterval timer = DateUtil.timer();
        log.info("[c-preheat] \u5f00\u59cb\u6267\u884c\u9884\u70ed\u5904\u7406");
        this.callPhaser(event);
        this.autoRegistrationConfig();
        this.clean();
        log.info("[c-preheat] \u9884\u70ed\u548c\u6ce8\u518c\u6267\u884c\u7ed3\u675f\uff0c\u603b\u8017\u65f6\uff1a{}", (Object)timer.intervalMs());
    }

    private void autoRegistrationConfig() {
        log.info("[c-preheat] \u5f00\u59cb\u6267\u884c\u670d\u52a1\u6ce8\u518c");
        for (RegistrationNotify registrationNotify : this.registrationNotifyList) {
            registrationNotify.readinessNotify();
        }
    }

    private void callPhaser(ApplicationReadyEvent event) {
        CountDownLatch countDownLatch = new CountDownLatch(this.preheatPhaserList.size());
        TimeInterval timer = DateUtil.timer();
        AtomicInteger errorPhaserCount = new AtomicInteger();
        for (PreheatPhaser preheatPhaser : this.preheatPhaserList) {
            this.executor.execute(() -> {
                TimeInterval handlerTimer = DateUtil.timer();
                try {
                    preheatPhaser.handle();
                    log.info("[c-preheat] {}\u9884\u70ed\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}", preheatPhaser.getClass(), (Object)handlerTimer.intervalMs());
                }
                catch (Exception e) {
                    log.error("[c-preheat] {}\u9884\u70ed\u5904\u7406\u5931\u8d25", preheatPhaser.getClass());
                    log.error(e.getMessage(), (Throwable)e);
                    errorPhaserCount.incrementAndGet();
                }
                countDownLatch.countDown();
            });
        }
        try {
            if (countDownLatch.await(this.properties.getExecuteTimeoutMills(), TimeUnit.MILLISECONDS)) {
                log.info("[c-preheat] \u9884\u70ed\u6267\u884c\u7ed3\u675f\uff0c\u603b\u6d88\u8017\u65f6\u95f4\uff1a{}", (Object)timer.intervalMs());
            } else {
                log.error("[c-preheat] \u6267\u884c\u65f6\u95f4\u8d85\u8fc7{},\u5f53\u524d\u6267\u884c\u65f6\u957f\uff1a{}", (Object)this.properties.getExecuteTimeoutMills(), (Object)timer.intervalMs());
            }
            if (errorPhaserCount.get() > 0) {
                log.error("[c-preheat] \u5e94\u7528\u7ec8\u6b62\u542f\u52a8\uff0c\u9884\u70ed\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5");
                ConfigurableApplicationContext applicationContext = event.getApplicationContext();
                applicationContext.stop();
                System.exit(0);
            }
        }
        catch (InterruptedException e) {
            log.error("[c-preheat] \u6267\u884c\u4e2d\u65ad," + e.getMessage(), (Throwable)e);
        }
    }

    private void clean() {
        this.executor.destroy();
        this.executor = null;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

