package com.bxm.component.preheat.config;

import com.bxm.component.preheat.properties.PreheatConfigurationProperties;
import com.bxm.component.preheat.registration.RegistrationNotify;
import com.bxm.newidea.component.core.PreheatPhaser;
import lombok.AllArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * @author liujia
 * @date 2022/07/26 16:32:38
 * @since 2.2.1
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(PreheatConfigurationProperties.class)
@AllArgsConstructor
public class PreheatAutoConfiguration {

    private PreheatConfigurationProperties properties;

    @Bean
    public PreheatApplicationReadyListener preheatApplicationReadyListener(List<PreheatPhaser> preheatPhaserList,
                                                                           List<RegistrationNotify> registrationNotifyList) {
        return new PreheatApplicationReadyListener(preheatPhaserList, registrationNotifyList, properties);
    }
}
