package com.bxm.component.preheat.phaser.mvc;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpUtil;
import com.bxm.component.preheat.phaser.mvc.internal.DetectValidParam;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.core.PreheatPhaser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;

import java.math.BigDecimal;

/**
 * webmvc框架预热，用于激活dispatchServlet的初始化和校验框架的初始化
 *
 * @author liujia
 * @date 2022/07/27 15:44:21
 * @since 2.2.1
 */
@Slf4j
public class WebMvcPreheatPhaser implements PreheatPhaser {

    @Value("${server.port:80}")
    private int port;

    @Override
    public void handle() {
        DetectValidParam param = new DetectValidParam();
        param.setStr(RandomUtil.randomString(5));
        param.setDate(DateUtil.nextMonth().toJdkDate());
        param.setDecimal(RandomUtil.randomBigDecimal(BigDecimal.ZERO, new BigDecimal("20")));
        param.setNum(RandomUtil.randomInt(10, 20));

        String requestUrl = "http://127.0.0.1:" + port + "/v1/expose/detect/valid";

        String response = HttpUtil.post(requestUrl, JSON.toJSONString(param));
        log.debug("[c-preheat] 探测mvc请求返回值:{}", response);
    }
}
