package com.bxm.component.preheat.phaser.redis;

import com.bxm.component.preheat.config.PreheatAutoConfiguration;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * redis连接预热
 *
 * @author liujia
 * @date 2022/07/27 16:33:39
 * @since 2.2.1
 */
@Configuration
@ConditionalOnClass(RedisStringAdapter.class)
@AutoConfigureAfter(PreheatAutoConfiguration.class)
public class RedisPreheatAutoConfiguration {

    @Bean
    @ConditionalOnBean(RedisStringAdapter.class)
    public RedisPreheatPhaser redisPreheatPhaser(RedisStringAdapter redisStringAdapter) {
        return new RedisPreheatPhaser(redisStringAdapter);
    }
}
