package com.bxm.component.preheat.phaser.redis;

import com.bxm.newidea.component.core.PreheatPhaser;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * redis链接预热，用于触发redis连接池的创建
 *
 * @author liujia
 * @date 2022/07/27 15:45:06
 * @since 2.2.1
 */
@Slf4j
@AllArgsConstructor
public class RedisPreheatPhaser implements PreheatPhaser {

    private RedisStringAdapter redisStringAdapter;

    @Override
    public void handle() {
        KeyGenerator tempKey = DefaultKeyGenerator.build("component", "cache", "temp");
        redisStringAdapter.get(tempKey, String.class);
    }
}
