/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.quartz.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.quartz.domain.ScheduleViewMapper;
import com.bxm.newidea.component.quartz.service.ScheduleJobService;
import com.bxm.newidea.component.quartz.vo.ScheduleJobBean;
import com.bxm.newidea.component.quartz.vo.ScheduleJobPageParam;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class ScheduleJobServiceImpl
implements InitializingBean,
ApplicationContextAware,
ScheduleJobService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private ScheduleViewMapper scheduleViewMapper;
    private Scheduler scheduler;
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() throws Exception {
        this.scheduler = (Scheduler)this.applicationContext.getBean(Scheduler.class);
        Map jobs = this.applicationContext.getBeansOfType(AbstractCustomJob.class);
        if (jobs.size() > 0) {
            for (AbstractCustomJob job : jobs.values()) {
                JobKey key = new JobKey(job.getJobName(), job.getGroup());
                if (StringUtils.isNotBlank((CharSequence)job.getCron())) {
                    if (!CronExpression.isValidExpression((String)job.getCron())) {
                        this.logger.error("jbo:[{},{}],cron\u8868\u8fbe\u5f0f[{}]\u9519\u8bef", new Object[]{job.getJobName(), job.getGroup(), job.getCron()});
                        break;
                    }
                    if (this.scheduler.checkExists(key)) continue;
                    JobDetail jobDetail = JobBuilder.newJob(((Object)((Object)job)).getClass()).withIdentity(job.getJobName(), job.getGroup()).build();
                    CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCron());
                    CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(job.getJobName(), job.getGroup()).withPriority(job.getPriority()).withSchedule((ScheduleBuilder)scheduleBuilder).withDescription(job.getDescription()).build();
                    if (job.getParam() != null) {
                        jobDetail.getJobDataMap().putAll(job.getParam());
                    }
                    this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
                    continue;
                }
                this.logger.info("{}-{}\u4e0d\u662f\u4e00\u4e2acron\u5b9a\u65f6\u4efb\u52a1", (Object)job.getJobName(), (Object)job.getGroup());
            }
        }
    }

    @Override
    public Message addSimpleJob(AbstractCustomJob job) {
        Preconditions.checkArgument((job != null ? 1 : 0) != 0);
        JobBuilder detail = JobBuilder.newJob(((Object)((Object)job)).getClass()).withIdentity(job.getJobName(), job.getGroup()).withDescription(job.getDescription());
        if (null != job.getParam()) {
            this.logger.warn("\u5b9a\u65f6\u4efb\u52a1\u5b9e\u4f53:{},{}", (Object)JSON.toJSONString((Object)((Object)job)), (Object)JSON.toJSONString(job.getParam()));
            detail.setJobData(new JobDataMap(job.getParam()));
        }
        SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withRepeatCount(job.getCount()).withIntervalInSeconds(1).withMisfireHandlingInstructionFireNow();
        Trigger trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)scheduleBuilder).withPriority(job.getPriority()).startAt(job.getStartTime()).build();
        Message message = Message.build((boolean)true);
        try {
            this.scheduler.scheduleJob(detail.build(), trigger);
        }
        catch (SchedulerException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            message.setMessage(e.getMessage()).setSuccess(false);
        }
        return message;
    }

    @Override
    public Message addCronJob(AbstractCustomJob job) {
        Preconditions.checkArgument((job != null ? 1 : 0) != 0);
        Preconditions.checkArgument((job.getCron() != null ? 1 : 0) != 0);
        JobBuilder detail = JobBuilder.newJob(((Object)((Object)job)).getClass()).withIdentity(job.getJobName(), job.getGroup()).withDescription(job.getDescription());
        if (null != job.getParam()) {
            detail.setJobData(new JobDataMap(job.getParam()));
        }
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCron()).withMisfireHandlingInstructionFireAndProceed();
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)scheduleBuilder).withPriority(job.getPriority());
        Trigger trigger = null != job.getStartTime() ? triggerBuilder.startAt(job.getStartTime()).build() : triggerBuilder.build();
        Message message = Message.build((boolean)true);
        try {
            this.scheduler.scheduleJob(detail.build(), trigger);
        }
        catch (SchedulerException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            message.setMessage(e.getMessage()).setSuccess(false);
        }
        return message;
    }

    @Override
    public Message update(ScheduleJobBean param) {
        ScheduleJobBean scheduleJobBean = this.getJob(param.getJobName(), param.getJobGroup());
        scheduleJobBean.setCronExpression(param.getCronExpression());
        scheduleJobBean.setDescription(param.getDescription());
        try {
            TriggerKey triggerKey = this.getTriggerKey(scheduleJobBean.getJobName(), scheduleJobBean.getJobGroup());
            if (!CronExpression.isValidExpression((String)scheduleJobBean.getCronExpression())) {
                return Message.build((boolean)false, (String)"cron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
            }
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJobBean.getCronExpression());
            CronTrigger cronTrigger = this.getCronTrigger(this.scheduler, scheduleJobBean.getJobName(), scheduleJobBean.getJobGroup());
            assert (cronTrigger != null);
            cronTrigger = (CronTrigger)cronTrigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).withPriority(scheduleJobBean.getPriority().intValue()).withDescription(scheduleJobBean.getDescription()).build();
            this.scheduler.rescheduleJob(triggerKey, (Trigger)cronTrigger);
            Trigger.TriggerState triggerState = this.scheduler.getTriggerState(triggerKey);
            if (scheduleJobBean.getParam() != null && scheduleJobBean.getParam().size() > 0) {
                cronTrigger.getJobDataMap().putAll(scheduleJobBean.getParam());
            }
            if (Trigger.TriggerState.PAUSED.name().equals(triggerState.name())) {
                this.pause(scheduleJobBean.getJobName(), scheduleJobBean.getJobGroup());
            }
            return Message.build((boolean)true);
        }
        catch (SchedulerException e) {
            this.logger.error("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            return Message.build((boolean)false, (String)"\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public Message run(String jobName, String jobGroup) {
        JobKey jobKey = this.getJobKey(jobName, jobGroup);
        try {
            this.scheduler.triggerJob(jobKey);
            return Message.build((boolean)true);
        }
        catch (SchedulerException e) {
            this.logger.error("\u8fd0\u884c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            return Message.build((boolean)false, (String)"\u8fd0\u884c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public Message resume(String jobName, String jobGroup) {
        JobKey jobKey = this.getJobKey(jobName, jobGroup);
        try {
            this.scheduler.resumeJob(jobKey);
            return Message.build((boolean)true);
        }
        catch (SchedulerException e) {
            this.logger.error("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            return Message.build((boolean)false, (String)"\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public Message pause(String jobName, String jobGroup) {
        JobKey jobKey = this.getJobKey(jobName, jobGroup);
        try {
            this.scheduler.pauseJob(jobKey);
            return Message.build((boolean)true);
        }
        catch (SchedulerException e) {
            this.logger.error("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            return Message.build((boolean)false, (String)"\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public Message remove(String jobName, String jobGroup) {
        JobKey jobKey = this.getJobKey(jobName, jobGroup);
        try {
            this.scheduler.deleteJob(jobKey);
            return Message.build((boolean)true);
        }
        catch (SchedulerException e) {
            this.logger.error("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            return Message.build((boolean)false, (String)"\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public PageWarper<ScheduleJobBean> queryJobs(ScheduleJobPageParam scheduleJobPageParam) {
        if (null == this.scheduleViewMapper) {
            return null;
        }
        PageWarper scheduleJobBeanPageWarper = new PageWarper(this.scheduleViewMapper.selectByPageNumSize(scheduleJobPageParam));
        try {
            if (CollectionUtils.isNotEmpty((Collection)scheduleJobBeanPageWarper.getList())) {
                for (ScheduleJobBean item : scheduleJobBeanPageWarper.getList()) {
                    Trigger.TriggerState state = this.scheduler.getTriggerState(this.getTriggerKey(item.getJobName(), item.getJobGroup()));
                    item.setStatus(state.name());
                    item.setPrevTime(new Date(item.getPrevFireTime()));
                    item.setNextTime(new Date(item.getNextFireTime()));
                }
            }
        }
        catch (SchedulerException e) {
            this.logger.error("\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
        return scheduleJobBeanPageWarper;
    }

    @Override
    public ScheduleJobBean getJob(String jobName, String jobGroup) {
        if (null == this.scheduleViewMapper) {
            return null;
        }
        return this.scheduleViewMapper.selectByJobNameAndJobGroup(jobName, jobGroup);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private TriggerKey getTriggerKey(String triggerName, String triggerGroup) {
        return TriggerKey.triggerKey((String)triggerName, (String)triggerGroup);
    }

    private JobKey getJobKey(String jobName, String jobGroup) {
        return JobKey.jobKey((String)jobName, (String)jobGroup);
    }

    private CronTrigger getCronTrigger(Scheduler scheduler, String jobName, String jobGroup) {
        try {
            return (CronTrigger)scheduler.getTrigger(this.getTriggerKey(jobName, jobGroup));
        }
        catch (SchedulerException e) {
            this.logger.error("\u83b7\u53d6cron\u8868\u8fbe\u5f0f\u89e6\u53d1\u5668\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

