/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.quartz.config;

import com.bxm.newidea.component.quartz.config.AutowireCapableBeanJobFactory;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.quartz.QuartzProperties;
import org.springframework.boot.autoconfigure.quartz.SchedulerFactoryBeanCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@EnableScheduling
@EnableConfigurationProperties(value={QuartzProperties.class})
@ConditionalOnProperty(prefix="spring.quartz", value={"job-store-type"})
@ConditionalOnMissingBean(name={"custonQuartzConfiguration"})
public class QuartzConfiguration {
    private final QuartzProperties properties;
    private final List<SchedulerFactoryBeanCustomizer> customizers;
    private final Executor taskExecutor;
    private final JobDetail[] jobDetails;
    private final Map<String, Calendar> calendars;
    private final Trigger[] triggers;
    private final ApplicationContext applicationContext;

    public QuartzConfiguration(QuartzProperties properties, ObjectProvider<List<SchedulerFactoryBeanCustomizer>> customizers, ObjectProvider<Executor> taskExecutor, ObjectProvider<JobDetail[]> jobDetails, ObjectProvider<Map<String, Calendar>> calendars, ObjectProvider<Trigger[]> triggers, ApplicationContext applicationContext) {
        this.properties = properties;
        this.customizers = (List)customizers.getIfAvailable();
        this.taskExecutor = (Executor)taskExecutor.getIfUnique();
        this.jobDetails = (JobDetail[])jobDetails.getIfAvailable();
        this.calendars = (Map)calendars.getIfAvailable();
        this.triggers = (Trigger[])triggers.getIfAvailable();
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean
    public SchedulerFactoryBean quartzScheduler() {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        schedulerFactoryBean.setJobFactory((JobFactory)new AutowireCapableBeanJobFactory(this.applicationContext.getAutowireCapableBeanFactory()));
        if (!this.properties.getProperties().isEmpty()) {
            schedulerFactoryBean.setQuartzProperties(this.asProperties(this.properties.getProperties()));
        }
        if (this.taskExecutor != null) {
            schedulerFactoryBean.setTaskExecutor(this.taskExecutor);
        }
        if (this.jobDetails != null && this.jobDetails.length > 0) {
            schedulerFactoryBean.setJobDetails(this.jobDetails);
        }
        if (this.calendars != null && !this.calendars.isEmpty()) {
            schedulerFactoryBean.setCalendars(this.calendars);
        }
        if (this.triggers != null && this.triggers.length > 0) {
            schedulerFactoryBean.setTriggers(this.triggers);
        }
        this.customize(schedulerFactoryBean);
        return schedulerFactoryBean;
    }

    private Properties asProperties(Map<String, String> source) {
        Properties properties = new Properties();
        properties.putAll(source);
        return properties;
    }

    private void customize(SchedulerFactoryBean schedulerFactoryBean) {
        if (this.customizers != null) {
            for (SchedulerFactoryBeanCustomizer customizer : this.customizers) {
                customizer.customize(schedulerFactoryBean);
            }
        }
    }
}

