/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.quartz;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public abstract class AbstractCustomJob
extends QuartzJobBean {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String jobName;
    private String cron;
    private String group;
    private String description;
    private int priority;
    private int count = -1;
    private Date startTime;
    private Map<String, Object> param;

    public AbstractCustomJob(String jobName, String cron, String description) {
        this.jobName = jobName;
        this.cron = cron;
        this.group = "default";
        this.description = description;
    }

    public AbstractCustomJob(String jobName, String group, String cron, String description) {
        this.jobName = jobName;
        this.cron = cron;
        this.group = group;
        this.description = description;
    }

    public AbstractCustomJob(String jobName, String group) {
        this.jobName = jobName;
        this.group = group;
    }

    public AbstractCustomJob(String jobName, String group, String cron, String description, int priority, Map<String, Object> param) {
        this.jobName = jobName;
        this.cron = cron;
        this.group = group;
        this.description = description;
        this.priority = priority;
        this.param = param;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void addParam(String key, Object value) {
        if (this.param == null) {
            this.param = Maps.newHashMap();
        }
        this.param.put(key, value);
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    protected void executeInternal(JobExecutionContext context) {
        this.logger.debug("\u5f53\u524d\u6267\u884c\u4efb\u52a1\u7c7b\uff1a{}, \u6267\u884c\u5f00\u59cb\u65f6\u95f4\uff1a{}", ((Object)((Object)this)).getClass(), (Object)DateUtils.formatDateTime((Date)new Date()));
        try {
            Message result = this.service();
            if (!result.isSuccess()) {
                this.saveLog(result);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.saveLog(Message.build().setMessage(e.getMessage()).setSuccess(false));
        }
        this.logger.debug("\u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)DateUtils.formatDateTime((Date)new Date()));
    }

    protected abstract Message service();

    protected void saveLog(Message errorMsg) {
        this.logger.error("quartz error:[{}]", (Object)errorMsg);
    }
}

