package com.bxm.newidea.component.redis;

import com.bxm.newidea.component.tools.RandomUtils;

import java.util.Date;
import java.util.List;

/**
 * redis操作代理
 *
 * @author liujia 2018/5/22 14:04
 */
public interface BaseRedisOperation {

    /**
     * 移除缓存的对象
     *
     * @param key key
     */
    Boolean remove(KeyGenerator key);

    /**
     * 批量删除多个key
     *
     * @param keys key列表
     * @return 删除成功的数量
     */
    Long remove(List<KeyGenerator> keys);

    /**
     * 设置key在seconds后过期
     *
     * @param key     key
     * @param seconds 过期秒数
     */
    void expire(KeyGenerator key, long seconds);

    /**
     * 在设定过期时间后进行随机的时间延长，防止出现集中过期的情况
     *
     * @param key     键
     * @param seconds 距离当前时间多久之后过期（单位：秒）
     */
    default void expireWithDisrupt(KeyGenerator key, long seconds) {
        expire(key, seconds + RandomUtils.nextLong(10, 400));
    }

    /**
     * 设置key在设定的expiredDate时过期
     *
     * @param key         key
     * @param expiredDate 具体的过期时间
     */
    void expire(KeyGenerator key, Date expiredDate);

    /**
     * 判断键是否已存在
     *
     * @param key key
     * @return true表示已存在
     */
    Boolean hasKey(KeyGenerator key);

    /**
     * 改名
     *
     * @param oldKey 要被替换的key
     * @param newKey 新的key
     * @deprecated redis集群分片的情况下此函数不支持
     */
    @Deprecated
    void rename(KeyGenerator oldKey, KeyGenerator newKey);
}
