package com.bxm.newidea.component.redis.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * kryo方式进行数据序列化，序列化速度快，序列化后存储空间更小
 * @deprecated 已序列化的数据当对象中的字段变更时无法反序列化
 * @author liujia
 */
public class KryoSerializer {

    private Logger logger = LoggerFactory.getLogger(getClass());

    public static final byte[] EMPTY_ARRAY = new byte[0];

    private static ThreadLocal<Kryox> kryoThreadLocal = ThreadLocal.withInitial(Kryox::new);

    public byte[] serialize(Object o) {
        if(o == null){
            return EMPTY_ARRAY;
        }
        Kryo kryo = kryoThreadLocal.get();

        Output output = new Output(64, -1);

        try {
            kryo.writeClassAndObject(output, o);
            return output.toBytes();
        } finally {
            closeOutputStream(output);
        }

    }

    @SuppressWarnings("unchecked")
    public <T> T deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        Input input = null;
        try {
            input = new Input(bytes);
            return (T) kryo.readClassAndObject(input);
        } finally {
            closeInputStream(input);
        }
    }

    private void closeOutputStream(OutputStream output) {
        if (output != null) {
            try {
                output.flush();
                output.close();
            } catch (Exception e) {
                logger.error("serialize object close outputStream exception", e);
            }
        }
    }

    private void closeInputStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            } catch (Exception e) {
                logger.error("serialize object close inputStream exception", e);
            }
        }
    }
}
