/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.impl.BaseRedisAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedisListAdapterImpl
extends BaseRedisAdapter
implements RedisListAdapter {
    private ListOperations operations;

    @Autowired
    public RedisListAdapterImpl(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.operations = redisTemplate.opsForList();
    }

    @Override
    public long leftPush(KeyGenerator generator, Object ... values) {
        return this.execPush(generator, true, values);
    }

    @Override
    public <T> long leftPush(KeyGenerator generator, List<T> value) {
        if (!CollectionUtils.isEmpty(value)) {
            return this.execPush(generator, true, value.toArray());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long execPush(KeyGenerator generator, boolean isLeft, Object[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return 0L;
        }
        String key = generator.gen();
        try {
            List<byte[]> result = this.convertToByteArray(values);
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            long l = isLeft ? this.operations.leftPushAll((Object)key, result) : this.operations.rightPushAll((Object)key, result);
            return l;
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }

    private List<byte[]> convertToByteArray(Object ... values) {
        ArrayList<byte[]> dataArray = new ArrayList<byte[]>();
        for (Object obj : values) {
            dataArray.add(this.serializer.serialize(obj));
        }
        return dataArray;
    }

    @Override
    public long rightPush(KeyGenerator generator, Object ... values) {
        return this.execPush(generator, false, values);
    }

    @Override
    public long size(KeyGenerator generator) {
        return this.operations.size((Object)generator.gen());
    }

    @Override
    public <T> T leftPop(KeyGenerator generator) {
        return this.execPop(generator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execPop(KeyGenerator generator, boolean isLeft) {
        try {
            String key = generator.gen();
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            Object value = isLeft ? this.operations.leftPop((Object)generator.gen()) : this.operations.rightPop((Object)generator.gen());
            Object t = this.deserialize(value);
            return t;
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }

    @Override
    public <T> T rightPop(KeyGenerator generator) {
        return this.execPop(generator, false);
    }

    @Override
    public <T> List<T> leftIndex(KeyGenerator generator, long index) {
        return this.range(generator, 0L, index);
    }

    @Override
    public <T> T index(KeyGenerator generator, long index) {
        Object value = this.operations.index((Object)generator.gen(), index);
        return this.deserialize(value);
    }

    @Override
    public <T> List<T> range(KeyGenerator generator, long start, long end) {
        ArrayList result = new ArrayList();
        List values = this.operations.range((Object)generator.gen(), start, end);
        if (!CollectionUtils.isEmpty((Collection)values)) {
            values.forEach(value -> result.add(this.deserialize(value)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leftTrim(KeyGenerator generator, long start, long end) {
        String key = generator.gen();
        try {
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            this.operations.trim((Object)generator.gen(), start, end);
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }
}

