/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.bxm.newidea.component.redis.impl.BaseRedisAdapter;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisZSetAdapterImpl
extends BaseRedisAdapter
implements RedisZSetAdapter {
    private ZSetOperations operations;

    @Autowired
    public RedisZSetAdapterImpl(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.operations = redisTemplate.opsForZSet();
    }

    @Override
    public ZSetOperations getOriginal() {
        return this.operations;
    }

    @Override
    public Boolean add(KeyGenerator generator, Object value, double score) {
        return this.operations.add((Object)generator.gen(), (Object)this.serializer.serialize(value), score);
    }

    @Override
    public long add(KeyGenerator generator, Set<ZSetOperations.TypedTuple> tuples) {
        return this.operations.add((Object)generator.gen(), this.serialize(tuples));
    }

    private Set<ZSetOperations.TypedTuple> serialize(Set<ZSetOperations.TypedTuple> tuples) {
        return tuples.stream().map(tuple -> new DefaultTypedTuple((Object)this.serializer.serialize(tuple.getValue()), tuple.getScore())).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double incrementScore(KeyGenerator generator, Object value, double amount) {
        String key = generator.gen();
        try {
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            double d = this.operations.incrementScore((Object)key, (Object)this.serializer.serialize(value), amount);
            return d;
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }

    @Override
    public Long remove(KeyGenerator generator, Object ... values) {
        return this.operations.remove((Object)generator.gen(), (Object[])this.serialize(values));
    }

    @Override
    public Long removeByRange(KeyGenerator generator, long start, long end) {
        return this.operations.removeRange((Object)generator.gen(), start, end);
    }

    @Override
    public Long removeByScore(KeyGenerator generator, double min, double max) {
        return this.operations.removeRangeByScore((Object)generator.gen(), min, max);
    }

    @Override
    public Long size(KeyGenerator generator) {
        return this.operations.size((Object)generator.gen());
    }

    @Override
    public Long count(KeyGenerator generator, double min, double max) {
        return this.operations.count((Object)generator.gen(), min, max);
    }

    @Override
    public Long rank(KeyGenerator generator, Object value) {
        return this.operations.rank((Object)generator.gen(), (Object)this.serializer.serialize(value));
    }

    @Override
    public Double score(KeyGenerator generator, Object value) {
        return this.operations.score((Object)generator.gen(), (Object)this.serializer.serialize(value));
    }

    @Override
    public <T> Set<ZSetOperations.TypedTuple<T>> rangeByScoreWithScores(KeyGenerator generator, double min, double max, long offset, long count, boolean isReversed) {
        Set result = isReversed ? this.operations.reverseRangeByScoreWithScores((Object)generator.gen(), min, max, offset, count) : this.operations.rangeByScoreWithScores((Object)generator.gen(), min, max, offset, count);
        return this.deserializeTuple(result);
    }

    private <T> Set<ZSetOperations.TypedTuple<T>> deserializeTuple(Set<ZSetOperations.TypedTuple> tuples) {
        LinkedHashSet<ZSetOperations.TypedTuple<T>> result = new LinkedHashSet<ZSetOperations.TypedTuple<T>>();
        for (ZSetOperations.TypedTuple tuple : tuples) {
            result.add((ZSetOperations.TypedTuple<T>)new DefaultTypedTuple(this.serializer.deserialize((byte[])tuple.getValue()), tuple.getScore()));
        }
        return result;
    }

    @Override
    public <T> Set<ZSetOperations.TypedTuple<T>> rangeByScoreWithScores(KeyGenerator generator, double min, double max, boolean isReversed) {
        Set result = isReversed ? this.operations.reverseRangeByScoreWithScores((Object)generator.gen(), min, max) : this.operations.rangeByScoreWithScores((Object)generator.gen(), min, max);
        return this.deserializeTuple(result);
    }

    private <T> Set<T> deserialize(Set<Object> data) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Object obj : data) {
            result.add(this.serializer.deserialize((byte[])obj));
        }
        return result;
    }

    @Override
    public <T> Set<T> range(KeyGenerator generator, long start, long end, boolean isReversed) {
        Set result = isReversed ? this.operations.reverseRange((Object)generator.gen(), start, end) : this.operations.range((Object)generator.gen(), start, end);
        return this.deserialize(result);
    }

    @Override
    public <T> Set<T> rangeByScore(KeyGenerator generator, double min, double max, boolean isReversed) {
        Set result = isReversed ? this.operations.reverseRangeByScore((Object)generator.gen(), min, max) : this.operations.rangeByScore((Object)generator.gen(), min, max);
        return this.deserialize(result);
    }

    @Override
    public <T> Set<T> rangeByScore(KeyGenerator generator, double min, double max, long offset, long count, boolean isReversed) {
        Set result = isReversed ? this.operations.reverseRangeByScore((Object)generator.gen(), min, max, offset, count) : this.operations.rangeByScore((Object)generator.gen(), min, max, offset, count);
        return this.deserialize(result);
    }

    @Override
    public Long intersectAndStore(KeyGenerator target, KeyGenerator source, KeyGenerator ... otherKeys) {
        return this.operations.intersectAndStore((Object)source.gen(), this.convertKeys(otherKeys), (Object)target.gen());
    }

    @Override
    public Long unionAndStore(KeyGenerator target, KeyGenerator source, KeyGenerator ... otherKeys) {
        return this.operations.unionAndStore((Object)source.gen(), this.convertKeys(otherKeys), (Object)target.gen());
    }
}

