/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.impl.BaseRedisAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class RedisSetAdapterImpl
extends BaseRedisAdapter
implements RedisSetAdapter {
    private SetOperations operations;

    @Autowired
    public RedisSetAdapterImpl(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.operations = redisTemplate.opsForSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long add(KeyGenerator generator, Object ... values) {
        String key = generator.gen();
        try {
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            Long l = this.operations.add((Object)generator.gen(), (Object[])this.serializeWithoutType(values));
            return l;
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }

    @Override
    public <T> Long remove(KeyGenerator generator, Object ... values) {
        return this.operations.remove((Object)generator.gen(), (Object[])this.serialize(values));
    }

    @Override
    public <T> Boolean exists(KeyGenerator generator, T value) {
        return this.operations.isMember((Object)generator.gen(), (Object)Objects.requireNonNull(this.getSerializerWithoutType().serialize(value)));
    }

    @Override
    public Long size(KeyGenerator generator) {
        return this.operations.size((Object)generator.gen());
    }

    @Override
    public <T> Set<T> getAllMembers(KeyGenerator generator, Class<T> clasz) {
        Cursor cursor = this.operations.scan((Object)generator.gen(), ScanOptions.scanOptions().count(10000L).build());
        HashSet<Object> result = new HashSet<Object>();
        RedisSerializer serializer = this.getSerializer(clasz);
        while (cursor.hasNext()) {
            result.add(serializer.deserialize((byte[])cursor.next()));
        }
        return result;
    }

    @Override
    public <T> Set<T> getAllMembers(KeyGenerator generator, TypeReference<T> typeReference) {
        Cursor cursor = this.operations.scan((Object)generator.gen(), ScanOptions.scanOptions().count(10000L).build());
        HashSet<Object> result = new HashSet<Object>();
        RedisSerializer serializer = this.getSerializer(typeReference);
        while (cursor.hasNext()) {
            result.add(serializer.deserialize((byte[])cursor.next()));
        }
        return result;
    }

    private <T> Set<T> deserialize(Set<Object> data, Class<T> clasz) {
        HashSet result = new HashSet();
        if (null != data && data.size() > 0) {
            data.forEach(item -> result.add(this.getSerializer(clasz).deserialize((byte[])item)));
        }
        return result;
    }

    @Override
    public <T> Set<T> difference(KeyGenerator generator, Class<T> clasz, KeyGenerator ... otherGenerators) {
        return this.deserialize(this.operations.difference((Object)generator.gen(), this.convertKeys(otherGenerators)), clasz);
    }

    @Override
    public Long differenceAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        return this.operations.differenceAndStore((Object)generator.gen(), this.convertKeys(otherGenerators), (Object)storeGenerator.gen());
    }

    @Override
    public <T> Set<T> inter(KeyGenerator generator, Class<T> clasz, KeyGenerator ... otherGenerators) {
        return this.deserialize(this.operations.intersect((Object)generator.gen(), this.convertKeys(otherGenerators)), clasz);
    }

    @Override
    public Long interAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        return this.operations.intersectAndStore((Object)generator.gen(), this.convertKeys(otherGenerators), (Object)storeGenerator.gen());
    }

    @Override
    public <T> Set<T> union(KeyGenerator generator, Class<T> clasz, KeyGenerator ... otherGenerators) {
        return this.deserialize(this.operations.union((Object)generator.gen(), this.convertKeys(otherGenerators)), clasz);
    }

    @Override
    public Long unionAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        return this.operations.unionAndStore((Object)generator.gen(), this.convertKeys(otherGenerators), (Object)storeGenerator.gen());
    }

    @Override
    public <T> Boolean move(KeyGenerator sourceKey, KeyGenerator targetKey, T item, Class<T> clasz) {
        return this.operations.move((Object)sourceKey.gen(), (Object)Objects.requireNonNull(this.getSerializer(clasz).serialize(item)), (Object)targetKey.gen());
    }

    @Override
    public SetOperations getOriginal() {
        return this.operations;
    }
}

