package com.bxm.newidea.component.redis;

import java.util.Date;
import java.util.List;

/**
 * redis操作代理
 * @author liujia 2018/5/22 14:04
 */
public interface BaseRedisOperation {

    /**
     * 移除缓存的对象
     * @param key key
     */
    Boolean remove(KeyGenerator key);

    /**
     * 批量删除多个key
     * @param keys key列表
     * @return 删除成功的数量
     */
    Long remove(List<KeyGenerator> keys);

    /**
     * 设置key在seconds后过期
     * @param key     key
     * @param seconds 过期秒数
     */
    void expire(KeyGenerator key, long seconds);

    /**
     * 设置key在设定的expiredDate时过期
     * @param key         key
     * @param expiredDate 具体的过期时间
     */
    void expire(KeyGenerator key, Date expiredDate);

    /**
     * 判断键是否已存在
     * @param key key
     * @return true表示已存在
     */
    Boolean hasKey(KeyGenerator key);
}
