package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.tools.StringUtils;

/**
 * 默认的key值创建器
 * @author liujia 2018/5/21 15:27
 */
public class DefaultKeyGenerator implements KeyGenerator {

    private String module;

    private String group;

    private String key;

    private DefaultKeyGenerator(String module, String group, String seed) {
        this.setGroup(group).setModule(module).setKey(seed);
    }

    private DefaultKeyGenerator(String module, String group) {
        this.setGroup(group).setModule(module);
    }

    private DefaultKeyGenerator() {
    }

    public static DefaultKeyGenerator build() {
        return new DefaultKeyGenerator();
    }

    public static DefaultKeyGenerator build(String module, String group) {
        return new DefaultKeyGenerator(module, group);
    }

    public static DefaultKeyGenerator build(String module, String group, String key) {
        return new DefaultKeyGenerator(module, group, key);
    }

    private static DefaultKeyGenerator build(DefaultKeyGenerator key) {
        return new DefaultKeyGenerator(key.module, key.group, key.key);
    }

    @Override
    public DefaultKeyGenerator setModule(String module) {
        this.module = module;
        return this;
    }

    @Override
    public DefaultKeyGenerator setGroup(String group) {
        this.group = group;
        return this;
    }

    @Override
    public DefaultKeyGenerator setKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public DefaultKeyGenerator appendKey(Object subKey) {
        if (StringUtils.isBlank(this.key)) {
            this.key = subKey.toString();
        } else {
            this.key += JOIN_CHAR + subKey;
        }
        return this;
    }

    @Override
    public String gen() {
        return this.module + JOIN_CHAR + this.group + JOIN_CHAR + this.key;
    }

    @Override
    public DefaultKeyGenerator copy() {
        return DefaultKeyGenerator.build(this);
    }

    @Override
    public String toString() {
        return gen();
    }
}
