package com.bxm.newidea.component.redis;

/**
 * 缓存key值生成器,用于规范生成key值的格式，增强可读性
 * @author liujia 2018/5/21 15:18
 */
public interface KeyGenerator {

    /**
     * redis key 连接符
     */
    String JOIN_CHAR = ":";

    /**
     * redis key最长的长度
     */
    int MAX_KEY_LENGTH = 150;

    /**
     * 设置模块
     * @param module 模块名称
     */
    KeyGenerator setModule(String module);

    /**
     * 功能分组
     * @param group 在模块下的功能分组
     */
    KeyGenerator setGroup(String group);

    /**
     * 设置键名称
     * @param key 键名称
     */
    KeyGenerator setKey(String key);

    /**
     * 追加下级键值
     * @param subKey 子键
     * @return 键名称
     */
    KeyGenerator appendKey(Object subKey);

    /**
     * 创建key，格式为module:group:key
     * @return 缓存使用的key值
     */
    String gen();

    /**
     * 复制当前key值
     * @return 复制的key
     */
    KeyGenerator copy();

    /**
     * 重写toString方法
     * @return
     */
    @Override
    String toString();
}
