/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@EnableCaching
@Configuration
@ConditionalOnMissingBean(name={"customRedisCacheConfiguration"})
public class RedisCacheConfiguration {
    @Bean
    public CacheManager cacheManager(RedisConnectionFactory connectionFactory) {
        return RedisCacheManager.create((RedisConnectionFactory)connectionFactory);
    }

    @Bean
    public RedisTemplate redisTemplate(RedisConnectionFactory factory) {
        StringRedisSerializer serializer = new StringRedisSerializer();
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)serializer);
        template.setHashKeySerializer((RedisSerializer)serializer);
        template.setEnableDefaultSerializer(false);
        template.setConnectionFactory(factory);
        template.afterPropertiesSet();
        return template;
    }
}

