/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.bxm.newidea.component.redis.impl.BaseRedisAdapter;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class RedisZSetAdapterImpl
extends BaseRedisAdapter
implements RedisZSetAdapter {
    private ZSetOperations operations;

    @Autowired
    public RedisZSetAdapterImpl(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.operations = redisTemplate.opsForZSet();
    }

    @Override
    public ZSetOperations getOriginal() {
        return this.operations;
    }

    @Override
    public Boolean add(KeyGenerator generator, Object value, double score) {
        return this.operations.add((Object)generator.gen(), (Object)Objects.requireNonNull(this.getSerializerWithoutType().serialize(value)), score);
    }

    @Override
    public Long add(KeyGenerator generator, Set<ZSetOperations.TypedTuple> tuples) {
        return this.operations.add((Object)generator.gen(), this.serialize(tuples));
    }

    private Set<ZSetOperations.TypedTuple> serialize(Set<ZSetOperations.TypedTuple> tuples) {
        return tuples.stream().map(tuple -> new DefaultTypedTuple((Object)this.getSerializerWithoutType().serialize(tuple.getValue()), tuple.getScore())).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Double incrementScore(KeyGenerator generator, T value, double amount) {
        String key = generator.gen();
        try {
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            Double d = this.operations.incrementScore((Object)key, (Object)Objects.requireNonNull(this.getSerializerWithoutType().serialize(value)), amount);
            return d;
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }

    @Override
    public <T> Long remove(KeyGenerator generator, Object ... values) {
        return this.operations.remove((Object)generator.gen(), (Object[])this.serialize(values));
    }

    @Override
    public Long removeByRange(KeyGenerator generator, long start, long end) {
        return this.operations.removeRange((Object)generator.gen(), start, end);
    }

    @Override
    public Long removeByScore(KeyGenerator generator, double min, double max) {
        return this.operations.removeRangeByScore((Object)generator.gen(), min, max);
    }

    @Override
    public Long size(KeyGenerator generator) {
        return this.operations.size((Object)generator.gen());
    }

    @Override
    public Long count(KeyGenerator generator, double min, double max) {
        return this.operations.count((Object)generator.gen(), min, max);
    }

    @Override
    public <T> Long rank(KeyGenerator generator, T value) {
        return this.operations.rank((Object)generator.gen(), (Object)Objects.requireNonNull(this.getSerializerWithoutType().serialize(value)));
    }

    @Override
    public <T> Double score(KeyGenerator generator, T value) {
        return this.operations.score((Object)generator.gen(), (Object)Objects.requireNonNull(this.getSerializerWithoutType().serialize(value)));
    }

    @Override
    public <T> Set<ZSetOperations.TypedTuple<T>> rangeByScoreWithScores(KeyGenerator generator, double min, double max, long offset, long count, boolean isReversed, Class<T> clasz) {
        Set result = isReversed ? this.operations.reverseRangeByScoreWithScores((Object)generator.gen(), min, max, offset, count) : this.operations.rangeByScoreWithScores((Object)generator.gen(), min, max, offset, count);
        return this.deserializeTuple(Objects.requireNonNull(result), clasz);
    }

    private <T> Set<ZSetOperations.TypedTuple<T>> deserializeTuple(Set<ZSetOperations.TypedTuple> tuples, Class<T> clasz) {
        LinkedHashSet<ZSetOperations.TypedTuple<T>> result = new LinkedHashSet<ZSetOperations.TypedTuple<T>>();
        if (null == tuples) {
            return result;
        }
        RedisSerializer serializer = this.getSerializer(clasz);
        for (ZSetOperations.TypedTuple tuple : tuples) {
            result.add((ZSetOperations.TypedTuple<T>)new DefaultTypedTuple(serializer.deserialize((byte[])tuple.getValue()), tuple.getScore()));
        }
        return result;
    }

    @Override
    public <T> Set<ZSetOperations.TypedTuple<T>> rangeByScoreWithScores(KeyGenerator generator, double min, double max, boolean isReversed, Class<T> clasz) {
        Set result = isReversed ? this.operations.reverseRangeByScoreWithScores((Object)generator.gen(), min, max) : this.operations.rangeByScoreWithScores((Object)generator.gen(), min, max);
        return this.deserializeTuple(Objects.requireNonNull(result), clasz);
    }

    private <T> Set<T> deserialize(Set<Object> data, Class<T> clasz) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Object obj : data) {
            result.add(this.getSerializer(clasz).deserialize((byte[])obj));
        }
        return result;
    }

    @Override
    public <T> Set<T> range(KeyGenerator generator, long start, long end, boolean isReversed, Class<T> clasz) {
        Set result = isReversed ? this.operations.reverseRange((Object)generator.gen(), start, end) : this.operations.range((Object)generator.gen(), start, end);
        return this.deserialize(Objects.requireNonNull(result), clasz);
    }

    @Override
    public <T> Set<ZSetOperations.TypedTuple<T>> rangeWithScores(KeyGenerator generator, long start, long end, Class<T> clasz) {
        Set result = this.operations.rangeWithScores((Object)generator.gen(), start, end);
        return this.deserializeTuple(result, clasz);
    }

    @Override
    public <T> Set<T> rangeByScore(KeyGenerator generator, double min, double max, boolean isReversed, Class<T> clasz) {
        Set result = isReversed ? this.operations.reverseRangeByScore((Object)generator.gen(), min, max) : this.operations.rangeByScore((Object)generator.gen(), min, max);
        return this.deserialize(Objects.requireNonNull(result), clasz);
    }

    @Override
    public <T> Set<T> rangeByScore(KeyGenerator generator, double min, double max, long offset, long count, boolean isReversed, Class<T> clasz) {
        Set result = isReversed ? this.operations.reverseRangeByScore((Object)generator.gen(), min, max, offset, count) : this.operations.rangeByScore((Object)generator.gen(), min, max, offset, count);
        return this.deserialize(Objects.requireNonNull(result), clasz);
    }

    @Override
    public Long intersectAndStore(KeyGenerator target, KeyGenerator source, KeyGenerator ... otherKeys) {
        return this.operations.intersectAndStore((Object)source.gen(), this.convertKeys(otherKeys), (Object)target.gen());
    }

    @Override
    public Long unionAndStore(KeyGenerator target, KeyGenerator source, KeyGenerator ... otherKeys) {
        return this.operations.unionAndStore((Object)source.gen(), this.convertKeys(otherKeys), (Object)target.gen());
    }
}

