/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.impl;

import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redisson.impl.BaseRedisAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RHyperLogLog;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HyperLogLogAdapterImpl
extends BaseRedisAdapter
implements HyperLogLogAdapter {
    @Autowired
    public HyperLogLogAdapterImpl(RedissonClient redissonClient) {
        super(redissonClient);
    }

    private RHyperLogLog hyperLogLogOperations(KeyGenerator keyGenerator) {
        return this.redissonClient.getHyperLogLog(keyGenerator.gen());
    }

    @SafeVarargs
    public final <T> Long add(KeyGenerator keyGenerator, T ... value) {
        AtomicLong atomicLong = new AtomicLong();
        for (T t : value) {
            boolean add = this.hyperLogLogOperations(keyGenerator).add((Object)this.serializerString(t));
            atomicLong.addAndGet(add ? 1L : 0L);
        }
        return atomicLong.get();
    }

    public Long size(KeyGenerator ... keyGenerators) {
        if (keyGenerators.length == 0) {
            return 0L;
        }
        List<String> strings = this.convertKeysNotFirst(keyGenerators);
        return this.hyperLogLogOperations(keyGenerators[0]).countWith((String[])strings.stream().toArray(String[]::new));
    }

    public Long union(KeyGenerator keyGenerator, KeyGenerator ... sourceKeyGenerators) {
        String[] keyGeneratorArray = (String[])Arrays.stream(sourceKeyGenerators).map(KeyGenerator::gen).toArray(String[]::new);
        this.hyperLogLogOperations(keyGenerator).mergeWith(keyGeneratorArray);
        return this.hyperLogLogOperations(keyGenerator).countWith(new String[0]);
    }

    @Override
    public Boolean remove(KeyGenerator keyGenerator) {
        return this.hyperLogLogOperations(keyGenerator).delete();
    }
}

