package com.bxm.newidea.component.redisson.config;

import com.bxm.newidea.component.redis.*;
import com.bxm.newidea.component.redisson.impl.*;
import com.bxm.newidea.component.redisson.utils.RateLimiterFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * 对redisson配置进行封装，适当的简化
 *
 * @author lowi
 * @date 2021/5/13 10:04
 */
@Slf4j
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(RedissonConfigurationProperties.class)
@ConditionalOnProperty({"component.redisson.type", "component.redisson.address"})
@Import(RedisClientRegister.class)
public class ComponentRedissonConfiguration {

    private ApplicationContext applicationContext;

    private RedissonConfigurationProperties properties;

    public ComponentRedissonConfiguration(ApplicationContext applicationContext,
                                          RedissonConfigurationProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Bean
    public SwitchMultiDataSourceHandler switchMultiDataSourceHandler() {
        return new SwitchMultiDataSourceHandler(applicationContext);
    }

    @Bean
    public HyperLogLogAdapter hyperLogLogAdapter(SwitchMultiDataSourceHandler client) {
        return new HyperLogLogAdapterImpl(client);
    }

    @Bean
    public DistributedLock distributedLock(SwitchMultiDataSourceHandler client) {
        return new RedissonDistributedLockImpl(client, properties);
    }

    @Bean
    public RedisHashMapAdapter redisHashMapAdapter(SwitchMultiDataSourceHandler client) {
        return new RedissonHashMapAdapterImpl(client);
    }

    @Bean
    public RedisListAdapter redisListAdapter(SwitchMultiDataSourceHandler client) {
        return new RedissonListAdapterImpl(client);
    }

    @Bean
    public RedisSetAdapter redisSetAdapter(SwitchMultiDataSourceHandler client) {
        return new RedissonSetAdapterImpl(client);
    }

    @Bean
    public RedisStringAdapter redisStringAdapter(SwitchMultiDataSourceHandler client) {
        return new RedissonStringAdapterImpl(client, properties);
    }

    @Bean
    public RedisZSetAdapter redisZSetAdapter(SwitchMultiDataSourceHandler client) {
        return new RedissonZSetAdapterImpl(client);
    }

    @Bean
    public RateLimiterFactory rateLimiterFactory(DistributedLock distributedLock, RedisStringAdapter redisStringAdapter) {
        return new RateLimiterFactory(distributedLock, redisStringAdapter);
    }
}
