package com.bxm.newidea.component.redisson.config;

import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 对redisson配置进行封装，适当的简化
 *
 * @author lowi
 * @date 2021/5/13 10:04
 */
@Slf4j
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(RedissonConfigurationProperties.class)
@ConditionalOnProperty({"component.redisson.type", "component.redisson.address"})
public class ComponentRedissonConfiguration {

    private RedissonConfigurationProperties properties;

    public ComponentRedissonConfiguration(RedissonConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(RedissonClient.class)
    public RedissonClientFactoryBean redissonClient() {
        RedissonClientHolder clientHolder = new RedissonClientHolder();
        clientHolder.setProperties(properties);

        return new RedissonClientFactoryBean(properties, clientHolder);
    }

}
