/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.config;

import com.bxm.newidea.component.redisson.config.RedissonClientHolder;
import com.bxm.newidea.component.redisson.config.RedissonMetaInfo;
import com.bxm.newidea.component.redisson.config.RedissonMethodInterceptor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.util.CollectionUtils;

public class RedissonClientBeanDefinitionFactory {
    private static final Logger log = LoggerFactory.getLogger(RedissonClientBeanDefinitionFactory.class);
    private RedissonClientHolder redissonClientHolder;

    public RedissonClientBeanDefinitionFactory(RedissonClientHolder redissonClientHolder) {
        this.redissonClientHolder = redissonClientHolder;
    }

    public BeanDefinition get(String dataSourceName, RedissonMetaInfo redissonMetaInfo, String[] activeProfiles) {
        AbstractBeanDefinition redissonClientBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(RedissonClient.class, () -> this.getRedissonClientBean(dataSourceName, redissonMetaInfo, activeProfiles)).getBeanDefinition();
        Objects.requireNonNull(redissonClientBeanDefinition, String.format("redisson\u5bf9\u5e94\u7684BeanDefinition\u4e0d\u5b58\u5728,\u6570\u636e\u6e90\u540d\u79f0\uff1a%s", dataSourceName));
        return redissonClientBeanDefinition;
    }

    private RedissonClient getRedissonClientBean(String dataSourceName, RedissonMetaInfo redissonMetaInfo, String[] activeProfiles) {
        List targetProfiles = Stream.of(activeProfiles).filter(activeProfile -> StringUtils.equalsAnyIgnoreCase((CharSequence)activeProfile, (CharSequence[])new CharSequence[]{"LOCAL", "DEV"})).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(targetProfiles)) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(RedissonClient.class);
            enhancer.setCallback((Callback)new RedissonMethodInterceptor(this.redissonClientHolder, redissonMetaInfo, dataSourceName));
            return (RedissonClient)enhancer.create();
        }
        return this.redissonClientHolder.get(dataSourceName, redissonMetaInfo);
    }
}

