/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.config;

import cn.hutool.core.util.ClassLoaderUtil;
import com.bxm.newidea.component.redisson.config.RedissonMetaInfo;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.config.BaseConfig;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.TransportMode;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.connection.balancer.RoundRobinLoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.awt.OSInfo;

public class RedissonClientHolder {
    private static final Logger log = LoggerFactory.getLogger(RedissonClientHolder.class);
    private Map<String, RedissonClient> redissonClientMap = new ConcurrentHashMap<String, RedissonClient>();

    public synchronized RedissonClient get(String dataSourceName, RedissonMetaInfo redissonMetaInfo) {
        if (null == this.redissonClientMap.get(dataSourceName)) {
            this.init(dataSourceName, redissonMetaInfo);
        }
        RedissonClient redissonClient = this.redissonClientMap.get(dataSourceName);
        Objects.requireNonNull(redissonClient, String.format("redissonClient\u4e0d\u5b58\u5728,\u6570\u636e\u6e90\u540d\u79f0\uff1a%s", dataSourceName));
        return redissonClient;
    }

    private void init(String dataSourceName, RedissonMetaInfo redissonMetaInfo) {
        long start = System.currentTimeMillis();
        Config config = this.buildConfig(redissonMetaInfo);
        switch (redissonMetaInfo.getType()) {
            case SINGLE: {
                config = this.buildSingleServer(config, redissonMetaInfo);
                break;
            }
            case CLUSTER: {
                config = this.clusterServersConfig(config, redissonMetaInfo);
                break;
            }
            case REPLICATED: {
                config = this.replicatedConfig(config, redissonMetaInfo);
                break;
            }
            case SENTINAL: {
                config = this.sentinelConfig(config, redissonMetaInfo);
                break;
            }
            case MASTER_SLAVE: {
                config = this.masterSlaveConfig(config, redissonMetaInfo);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u672a\u63d0\u4f9bcomponent.redisson.type\u914d\u7f6e\uff0c\u6216\u8005\u914d\u7f6e\u503c\u4e0d\u5728\u679a\u4e3e\u8303\u56f4\u5185");
            }
        }
        this.redissonClientMap.put(dataSourceName, Redisson.create((Config)config));
        if (log.isDebugEnabled()) {
            log.debug("redisson \u542f\u52a8\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
    }

    private Config buildConfig(RedissonMetaInfo redissonMetaInfo) {
        Config config = new Config();
        OSInfo.OSType osType = OSInfo.getOSType();
        config.setEventLoopGroup((EventLoopGroup)new NioEventLoopGroup());
        config.setTransportMode(TransportMode.NIO);
        if (redissonMetaInfo.getTransportMode() != null) {
            if (TransportMode.EPOLL.equals((Object)redissonMetaInfo.getTransportMode())) {
                if (OSInfo.OSType.LINUX.equals((Object)osType)) {
                    config.setEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup());
                    config.setTransportMode(TransportMode.EPOLL);
                }
            } else if (TransportMode.KQUEUE.equals((Object)redissonMetaInfo.getTransportMode()) && OSInfo.OSType.MACOSX.equals((Object)osType)) {
                config.setEventLoopGroup((EventLoopGroup)new KQueueEventLoopGroup());
                config.setTransportMode(TransportMode.KQUEUE);
            }
        }
        config.setCodec((Codec)new StringCodec());
        return config;
    }

    private void setBaseConfig(BaseConfig serverConfig, RedissonMetaInfo redissonMetaInfo) {
        if (null != redissonMetaInfo.getPassword()) {
            serverConfig.setPassword(redissonMetaInfo.getPassword());
        }
        serverConfig.setClientName(redissonMetaInfo.getClientName());
        serverConfig.setSubscriptionsPerConnection(redissonMetaInfo.getSubscriptionsPerConnection());
        serverConfig.setConnectTimeout(redissonMetaInfo.getConnectTimeout());
        serverConfig.setIdleConnectionTimeout(redissonMetaInfo.getIdleConnectionTimeout());
        serverConfig.setTimeout(redissonMetaInfo.getTimeout());
        serverConfig.setRetryAttempts(redissonMetaInfo.getRetryAttempts());
        serverConfig.setRetryInterval(redissonMetaInfo.getRetryInterval());
    }

    private void setMasterSlaveConfig(BaseMasterSlaveServersConfig slaveConfig, RedissonMetaInfo redissonMetaInfo) {
        slaveConfig.setMasterConnectionMinimumIdleSize(redissonMetaInfo.getMasterConnectionMinimumIdleSize());
        slaveConfig.setMasterConnectionPoolSize(redissonMetaInfo.getMasterConnectionPoolSize());
        slaveConfig.setSlaveConnectionMinimumIdleSize(redissonMetaInfo.getSlaveConnectionMinimumIdleSize());
        slaveConfig.setSlaveConnectionPoolSize(redissonMetaInfo.getSlaveConnectionPoolSize());
        slaveConfig.setSubscriptionConnectionMinimumIdleSize(redissonMetaInfo.getSubscriptionConnectionMinimumIdleSize());
        slaveConfig.setSubscriptionConnectionPoolSize(redissonMetaInfo.getSubscriptionConnectionPoolSize());
        slaveConfig.setSubscriptionMode(redissonMetaInfo.getSubscriptionMode());
        slaveConfig.setReadMode(redissonMetaInfo.getReadMode());
        try {
            if (null != redissonMetaInfo.getLoadBalancer()) {
                LoadBalancer loadBalancer = (LoadBalancer)ClassLoaderUtil.loadClass((String)redissonMetaInfo.getLoadBalancer()).newInstance();
                slaveConfig.setLoadBalancer(loadBalancer);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("\u914d\u7f6e\u7684[{}]\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff0c\u9ed8\u8ba4\u4f7f\u7528\u8f6e\u8be2", (Object)redissonMetaInfo.getLoadBalancer());
            slaveConfig.setLoadBalancer((LoadBalancer)new RoundRobinLoadBalancer());
        }
    }

    private Config sentinelConfig(Config config, RedissonMetaInfo redissonMetaInfo) {
        Preconditions.checkNotNull((Object)redissonMetaInfo.getAddress(), (Object)"\u54e8\u5175\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u8fde\u63a5\u5730\u5740\uff1acomponent.redisson.address");
        Preconditions.checkNotNull((Object)redissonMetaInfo.getMasterName(), (Object)"\u54e8\u5175\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u4e3b\u8282\u70b9\u540d\u79f0\uff1acomponent.redisson.masterName");
        SentinelServersConfig serverConfig = config.useSentinelServers();
        this.setBaseConfig((BaseConfig)serverConfig, redissonMetaInfo);
        this.setMasterSlaveConfig((BaseMasterSlaveServersConfig)serverConfig, redissonMetaInfo);
        serverConfig.setMasterName(redissonMetaInfo.getMasterName());
        serverConfig.addSentinelAddress(StringUtils.split((String)redissonMetaInfo.getAddress(), (String)","));
        if (null != redissonMetaInfo.getSentinelPassword()) {
            serverConfig.setSentinelPassword(redissonMetaInfo.getSentinelPassword());
        }
        serverConfig.setDatabase(redissonMetaInfo.getDatabase());
        return config;
    }

    private Config replicatedConfig(Config config, RedissonMetaInfo redissonMetaInfo) {
        Preconditions.checkNotNull((Object)redissonMetaInfo.getAddress(), (Object)"\u4e91\u6258\u7ba1\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u8fde\u63a5\u5730\u5740\uff1acomponent.redisson.address");
        ReplicatedServersConfig serverConfig = config.useReplicatedServers();
        serverConfig.addNodeAddress(StringUtils.split((String)redissonMetaInfo.getAddress(), (String)","));
        this.setBaseConfig((BaseConfig)serverConfig, redissonMetaInfo);
        this.setMasterSlaveConfig((BaseMasterSlaveServersConfig)serverConfig, redissonMetaInfo);
        serverConfig.setDatabase(redissonMetaInfo.getDatabase());
        serverConfig.setScanInterval(redissonMetaInfo.getClusterScanInterval());
        return config;
    }

    private Config masterSlaveConfig(Config config, RedissonMetaInfo redissonMetaInfo) {
        Preconditions.checkNotNull((Object)redissonMetaInfo.getAddress(), (Object)"\u4e3b\u4ece\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u4e3b\u8282\u70b9\u8fde\u63a5\u5730\u5740\uff1acomponent.redisson.address");
        Preconditions.checkNotNull((Object)redissonMetaInfo.getSlaveAddress(), (Object)"\u4e3b\u4ece\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u4ece\u8282\u70b9\u8fde\u63a5\u5730\u5740:component.redisson.slaveAddress");
        MasterSlaveServersConfig serverConfig = config.useMasterSlaveServers();
        serverConfig.setMasterAddress(redissonMetaInfo.getAddress());
        serverConfig.setSlaveAddresses((Set)Sets.newHashSet((Object[])StringUtils.split((String)redissonMetaInfo.getSlaveAddress(), (String)",")));
        this.setBaseConfig((BaseConfig)serverConfig, redissonMetaInfo);
        this.setMasterSlaveConfig((BaseMasterSlaveServersConfig)serverConfig, redissonMetaInfo);
        serverConfig.setDatabase(redissonMetaInfo.getDatabase());
        return config;
    }

    private Config buildSingleServer(Config config, RedissonMetaInfo redissonMetaInfo) {
        Preconditions.checkNotNull((Object)redissonMetaInfo.getAddress(), (Object)"\u5355\u5b9e\u4f8b\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u8fde\u63a5\u5730\u5740\uff1acomponent.redisson.address");
        SingleServerConfig serverConfig = config.useSingleServer();
        serverConfig.setAddress(redissonMetaInfo.getAddress());
        this.setBaseConfig((BaseConfig)serverConfig, redissonMetaInfo);
        serverConfig.setDatabase(redissonMetaInfo.getDatabase());
        serverConfig.setSubscriptionConnectionMinimumIdleSize(redissonMetaInfo.getSubscriptionConnectionMinimumIdleSize());
        serverConfig.setSubscriptionConnectionPoolSize(redissonMetaInfo.getSubscriptionConnectionPoolSize());
        serverConfig.setConnectionMinimumIdleSize(redissonMetaInfo.getConnectionMinimumIdleSize());
        return config;
    }

    private Config clusterServersConfig(Config config, RedissonMetaInfo redissonMetaInfo) {
        Preconditions.checkNotNull((Object)redissonMetaInfo.getAddress(), (Object)"\u96c6\u7fa4\u6a21\u5f0f\u5fc5\u987b\u63d0\u4f9b\u8fde\u63a5\u5730\u5740\uff1acomponent.redisson.address");
        ClusterServersConfig serverConfig = config.useClusterServers();
        serverConfig.addNodeAddress(StringUtils.split((String)redissonMetaInfo.getAddress(), (String)","));
        this.setBaseConfig((BaseConfig)serverConfig, redissonMetaInfo);
        this.setMasterSlaveConfig((BaseMasterSlaveServersConfig)serverConfig, redissonMetaInfo);
        return config;
    }
}

