/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redisson.impl;

import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.redisson.config.RedissonConfigurationProperties;
import com.bxm.newidea.component.redisson.config.SwitchMultiDataSourceHandler;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonDistributedLockImpl
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedissonDistributedLockImpl.class);
    private SwitchMultiDataSourceHandler switchMultiDataSourceHandler;
    private RedissonConfigurationProperties redissonConfigurationProperties;

    public RedissonDistributedLockImpl(SwitchMultiDataSourceHandler switchMultiDataSourceHandler, RedissonConfigurationProperties redissonConfigurationProperties) {
        this.switchMultiDataSourceHandler = switchMultiDataSourceHandler;
        this.redissonConfigurationProperties = redissonConfigurationProperties;
    }

    public boolean lock(String resource) {
        return this.lock(resource, 5L, TimeUnit.SECONDS);
    }

    public boolean lock(String resource, long time, TimeUnit timeUnit) {
        String key = this.buildKey(resource);
        RLock rlock = this.switchMultiDataSourceHandler.getRedissonClient(this.redissonConfigurationProperties.getDistributeDataSource()).getLock(key);
        try {
            return rlock.tryLock(-1L, time, timeUnit);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            rlock.unlock();
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private String buildKey(String resource) {
        return DefaultKeyGenerator.build((String)"biz", (String)"db", (String)resource).gen();
    }

    private boolean tryLock(String lockKey, TimeUnit unit, int waitTime, int leaseTime) {
        String key = this.buildKey(lockKey);
        RLock lock = this.switchMultiDataSourceHandler.getRedissonClient(this.redissonConfigurationProperties.getDistributeDataSource()).getLock(key);
        try {
            return lock.tryLock((long)waitTime, (long)leaseTime, unit);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            lock.unlock();
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void unlock(String resource) {
        String key = this.buildKey(resource);
        RLock lock = this.switchMultiDataSourceHandler.getRedissonClient(this.redissonConfigurationProperties.getDistributeDataSource()).getLock(key);
        try {
            lock.unlock();
        }
        catch (Exception e) {
            log.warn("\u5f53\u524dkey\u9501\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u89e3\u9501\u4e5f\u6ca1\u7528\uff0cresource\uff1a{}", (Object)resource, (Object)e);
        }
    }
}

