/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.BaseRedisAdapter;
import com.bxm.newidea.component.tools.NumberUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class RedisHashMapAdapterImpl
extends BaseRedisAdapter
implements RedisHashMapAdapter {
    private HashOperations<String, String, Object> hashOperations;

    @Autowired
    public RedisHashMapAdapterImpl(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.hashOperations = redisTemplate.opsForHash();
    }

    public <T> void put(KeyGenerator generator, String subKey, T value) {
        Assert.notNull((Object)generator, (String)"key\u6784\u5efa\u5668\u5fc5\u987b\u4f20\u9012");
        this.hashOperations.put((Object)generator.gen(), (Object)subKey, (Object)Objects.requireNonNull(this.getSerializerWithoutType().serialize(value)));
    }

    public void putLong(KeyGenerator generator, String subKey, Long value) {
        if (generator == null || null == value) {
            return;
        }
        this.hashOperations.put((Object)generator.gen(), (Object)subKey, (Object)Objects.requireNonNull(this.stringSerializer.serialize((Object)value.toString())));
    }

    public <T> void putAll(KeyGenerator generator, Map<String, T> values) {
        if (values == null) {
            return;
        }
        HashMap convertResult = Maps.newHashMap();
        RedisSerializer serializer = this.getSerializerWithoutType();
        values.forEach((key, value) -> convertResult.put(key, serializer.serialize(value)));
        this.hashOperations.putAll((Object)generator.gen(), (Map)convertResult);
    }

    public <T> T get(KeyGenerator generator, String subKey, Class<T> clasz) {
        String key = generator.gen();
        Object value = this.hashOperations.get((Object)key, (Object)subKey);
        if (null == value) {
            return null;
        }
        return this.deserialize(value, clasz);
    }

    public <T> T get(KeyGenerator generator, String subKey, TypeReference<T> typeReference) {
        String key = generator.gen();
        Object value = this.hashOperations.get((Object)key, (Object)subKey);
        if (null == value) {
            return null;
        }
        return (T)this.getSerializer(typeReference).deserialize((byte[])value);
    }

    public Long getLong(KeyGenerator generator, String subKey) {
        Object value = this.hashOperations.get((Object)generator.gen(), (Object)subKey);
        if (null == value) {
            return 0L;
        }
        return NumberUtils.parseToLong((String)((String)this.stringSerializer.deserialize((byte[])value)));
    }

    public Set<String> keys(KeyGenerator generator) {
        return this.hashOperations.keys((Object)generator.gen());
    }

    public <T> List<T> values(KeyGenerator generator, Class<T> clasz) {
        List result = this.hashOperations.values((Object)generator.gen());
        RedisSerializer serializer = this.getSerializer(clasz);
        return result.stream().map(item -> serializer.deserialize((byte[])item)).collect(Collectors.toList());
    }

    public <T> List<T> values(KeyGenerator generator, TypeReference<T> typeReference) {
        List result = this.hashOperations.values((Object)generator.gen());
        RedisSerializer serializer = this.getSerializer(typeReference);
        return result.stream().map(item -> serializer.deserialize((byte[])item)).collect(Collectors.toList());
    }

    public <T> List<T> multiGet(KeyGenerator generator, Collection<String> subKeys, Class<T> clasz) {
        List result = this.hashOperations.multiGet((Object)generator.gen(), subKeys);
        RedisSerializer serializer = this.getSerializer(clasz);
        return result.stream().filter(item -> null != item).map(item -> serializer.deserialize((byte[])item)).collect(Collectors.toList());
    }

    public <T> List<T> multiGet(KeyGenerator generator, Collection<String> subKeys, TypeReference<T> typeReference) {
        List result = this.hashOperations.multiGet((Object)generator.gen(), subKeys);
        RedisSerializer serializer = this.getSerializer(typeReference);
        return result.stream().filter(item -> null != item).map(item -> serializer.deserialize((byte[])item)).collect(Collectors.toList());
    }

    public <T> Map<String, T> entries(KeyGenerator generator, Class<T> clasz) {
        return this.getEntries(generator, clasz, null);
    }

    public <T> Map<String, T> entries(KeyGenerator generator, TypeReference<T> typeReference) {
        return this.getEntries(generator, null, typeReference);
    }

    private <T> Map<String, T> getEntries(KeyGenerator generator, Class<T> clasz, TypeReference<T> typeReference) {
        RedisSerializer serializer;
        Cursor cursor = this.hashOperations.scan((Object)generator.gen(), ScanOptions.scanOptions().count(10000L).build());
        HashMap result = new HashMap();
        RedisSerializer redisSerializer = serializer = null == clasz ? this.getSerializer(typeReference) : this.getSerializer(clasz);
        while (cursor.hasNext()) {
            Map.Entry entry = (Map.Entry)cursor.next();
            result.put(entry.getKey(), serializer.deserialize((byte[])entry.getValue()));
        }
        return result;
    }

    public Boolean exists(KeyGenerator generator, String subKey) {
        return this.hashOperations.hasKey((Object)generator.gen(), (Object)subKey);
    }

    public Long remove(KeyGenerator generator, String ... subKeys) {
        if (ArrayUtils.isEmpty((Object[])subKeys)) {
            return 0L;
        }
        return this.hashOperations.delete((Object)generator.gen(), (Object[])subKeys);
    }

    public Long length(KeyGenerator generator) {
        return this.hashOperations.size((Object)generator.gen());
    }

    public Long increment(KeyGenerator generator, String subKey, int amount) {
        return this.hashOperations.increment((Object)generator.gen(), (Object)subKey, (long)amount);
    }
}

