/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis;

import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Component
public class DistributedLock {
    @Resource
    private RedisTemplate redisTemplate;

    @Autowired
    public DistributedLock(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean lock(String resource, String reqeustId) {
        return this.lock(resource, reqeustId, 5L, TimeUnit.SECONDS);
    }

    public boolean lock(String resource, String reqeustId, long time, TimeUnit timeUnit) {
        String key = this.buildKey(resource);
        Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)reqeustId.getBytes());
        this.redisTemplate.expire((Object)key, time, timeUnit);
        return result;
    }

    private String buildKey(String resource) {
        return DefaultKeyGenerator.build((String)"biz", (String)"db", (String)resource).gen();
    }

    public boolean unlock(String resource, String requestId) {
        String key = this.buildKey(resource);
        String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        byte[] requestByteArray = requestId.getBytes();
        Object result = this.redisTemplate.execute((RedisScript)new DefaultRedisScript(script, Long.class), (List)Lists.newArrayList((Object[])new String[]{key}), new Object[]{requestByteArray});
        return new Long(1L).equals(result);
    }
}

