/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Component
public class DistributedLockImpl
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockImpl.class);
    @Resource
    private RedisTemplate redisTemplate;

    @Autowired
    public DistributedLockImpl(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    private String buildKey(String resource) {
        return DefaultKeyGenerator.build((String)"biz", (String)"db", (String)resource).gen();
    }

    private String getRequestId() {
        return Thread.currentThread().getName() + ":" + Thread.currentThread().getId();
    }

    public boolean lock(String resource) {
        return this.lock(resource, 5L, TimeUnit.SECONDS);
    }

    public boolean lock(String resource, long time, TimeUnit timeUnit) {
        String key = this.buildKey(resource);
        boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)this.getRequestId().getBytes());
        this.redisTemplate.expire((Object)key, time, timeUnit);
        return result;
    }

    public void unlock(String resource) {
        String key = this.buildKey(resource);
        String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        byte[] requestByteArray = this.getRequestId().getBytes();
        Object result = this.redisTemplate.execute((RedisScript)new DefaultRedisScript(script, Long.class), (List)Lists.newArrayList((Object[])new String[]{key}), new Object[]{requestByteArray});
        if (!new Long(1L).equals(result) && log.isDebugEnabled()) {
            log.debug("[{}]\u89e3\u9501\u5931\u8d25", (Object)resource);
        }
    }
}

