package com.bxm.newidea.component.redis.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

/**
 * redis 默认的缓存配置，如果需要覆盖，可以在项目中指定beanname为redisCacheConfiguration的类进行覆盖
 * @author liujia
 */
@EnableCaching
@Configuration
@ConditionalOnMissingBean(name = "customRedisCacheConfiguration")
public class RedisCacheConfiguration {

    @Bean
    public CacheManager cacheManager(RedisConnectionFactory connectionFactory) {
        return RedisCacheManager.create(connectionFactory);
    }

    @SuppressWarnings("unchecked")
    @Bean
    public RedisTemplate redisTemplate(RedisConnectionFactory factory) {
        RedisSerializer<String> serializer = new StringRedisSerializer();

        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer(serializer);
        template.setHashKeySerializer(serializer);

        template.setEnableDefaultSerializer(false);
        template.setConnectionFactory(factory);
        template.afterPropertiesSet();
        return template;
    }
}
