/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.config;

import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.config.BeanByNameHandler;
import com.bxm.newidea.component.schedule.rpc.ScheduleFeignService;
import com.bxm.newidea.component.schedule.rpc.ScheduleServiceImpl;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="xxl.job.executor")
public class XxlJobConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XxlJobConfiguration.class);
    private static final String EXECUTOR_IP = "executorIp";
    private static final int DEFAULT_PORT = 19099;
    private String adminAddresses;
    private String appName;
    private String ip;
    private int port = 19099;
    private String accessToken;
    private String logPath;
    private int logRetentionDays;
    private final EurekaInstanceConfig instance;
    private final InetUtils inetUtils;

    @Autowired(required=false)
    public XxlJobConfiguration(EurekaInstanceConfig instance, InetUtils inetUtils) {
        this.instance = instance;
        this.inetUtils = inetUtils;
    }

    @Bean
    public ScheduleService scheduleService(ScheduleFeignService scheduleFeignService) {
        return new ScheduleServiceImpl(this, scheduleFeignService);
    }

    @Bean
    public BeanByNameHandler beanByNameHandler() {
        return new BeanByNameHandler();
    }

    @Bean(initMethod="start", destroyMethod="destroy")
    @ConditionalOnProperty(name={"xxl.job.executor.app-name"})
    public XxlJobSpringExecutor xxlJobExecutor() {
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        if (StringUtils.isBlank((String)this.appName)) {
            if (null != this.instance) {
                this.appName = this.instance.getAppname();
            } else {
                throw new IllegalArgumentException("\u4f7f\u7528\u8c03\u5ea6\u670d\u52a1\uff0c\u5fc5\u987b\u63d0\u4f9bxxl.job.executor.app-name\u914d\u7f6e\u5c5e\u6027");
            }
        }
        if (StringUtils.isBlank((String)this.ip)) {
            this.ip = System.getProperty(EXECUTOR_IP);
            if (StringUtils.isBlank((String)this.ip)) {
                if (null != this.inetUtils) {
                    this.ip = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
                } else {
                    throw new IllegalArgumentException("\u4f7f\u7528\u8c03\u5ea6\u670d\u52a1\uff0c\u5fc5\u987b\u63d0\u4f9bxxl.job.executor.ip\u914d\u7f6e\u5c5e\u6027");
                }
            }
        }
        if (StringUtils.isBlank((String)this.adminAddresses)) {
            throw new IllegalArgumentException("\u4f7f\u7528\u8c03\u5ea6\u670d\u52a1\uff0c\u5fc5\u987b\u63d0\u4f9bxxl.job.executor.admin-address\u914d\u7f6e\u5c5e\u6027");
        }
        if (19099 == this.port) {
            log.info("\u8c03\u5ea6\u670d\u52a1\u56de\u8c03\u63a5\u53e3\u4f7f\u7528\u4e86\u9ed8\u8ba4\u7684[{}]\u7aef\u53e3\uff0c\u8bf7\u6ce8\u610f\u90e8\u7f72\u65f6\u7684\u7aef\u53e3\u51b2\u7a81\u95ee\u9898", (Object)19099);
        }
        xxlJobSpringExecutor.setAdminAddresses(this.adminAddresses);
        xxlJobSpringExecutor.setAppName(this.appName);
        xxlJobSpringExecutor.setIp(this.ip);
        xxlJobSpringExecutor.setPort(this.port);
        xxlJobSpringExecutor.setAccessToken(this.accessToken);
        xxlJobSpringExecutor.setLogPath(this.logPath);
        xxlJobSpringExecutor.setLogRetentionDays(this.logRetentionDays);
        return xxlJobSpringExecutor;
    }

    public String getAdminAddresses() {
        return this.adminAddresses;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public int getLogRetentionDays() {
        return this.logRetentionDays;
    }

    public EurekaInstanceConfig getInstance() {
        return this.instance;
    }

    public InetUtils getInetUtils() {
        return this.inetUtils;
    }

    public void setAdminAddresses(String adminAddresses) {
        this.adminAddresses = adminAddresses;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public void setLogRetentionDays(int logRetentionDays) {
        this.logRetentionDays = logRetentionDays;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XxlJobConfiguration)) {
            return false;
        }
        XxlJobConfiguration other = (XxlJobConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$adminAddresses = this.getAdminAddresses();
        String other$adminAddresses = other.getAdminAddresses();
        if (this$adminAddresses == null ? other$adminAddresses != null : !this$adminAddresses.equals(other$adminAddresses)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$logPath = this.getLogPath();
        String other$logPath = other.getLogPath();
        if (this$logPath == null ? other$logPath != null : !this$logPath.equals(other$logPath)) {
            return false;
        }
        if (this.getLogRetentionDays() != other.getLogRetentionDays()) {
            return false;
        }
        EurekaInstanceConfig this$instance = this.getInstance();
        EurekaInstanceConfig other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !this$instance.equals(other$instance)) {
            return false;
        }
        InetUtils this$inetUtils = this.getInetUtils();
        InetUtils other$inetUtils = other.getInetUtils();
        return !(this$inetUtils == null ? other$inetUtils != null : !this$inetUtils.equals(other$inetUtils));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XxlJobConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $adminAddresses = this.getAdminAddresses();
        result = result * 59 + ($adminAddresses == null ? 43 : $adminAddresses.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        result = result * 59 + this.getPort();
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $logPath = this.getLogPath();
        result = result * 59 + ($logPath == null ? 43 : $logPath.hashCode());
        result = result * 59 + this.getLogRetentionDays();
        EurekaInstanceConfig $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : $instance.hashCode());
        InetUtils $inetUtils = this.getInetUtils();
        result = result * 59 + ($inetUtils == null ? 43 : $inetUtils.hashCode());
        return result;
    }

    public String toString() {
        return "XxlJobConfiguration(adminAddresses=" + this.getAdminAddresses() + ", appName=" + this.getAppName() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", accessToken=" + this.getAccessToken() + ", logPath=" + this.getLogPath() + ", logRetentionDays=" + this.getLogRetentionDays() + ", instance=" + this.getInstance() + ", inetUtils=" + this.getInetUtils() + ")";
    }
}

