package com.bxm.newidea.component.schedule.config;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.schedule.constant.CommonConstant;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * 任务Handler（Bean模式）
 * <p>
 * 开发步骤：
 * 1、继承"IJobHandler"：“com.xxl.job.core.handler.IJobHandler”；
 * 2、注册到Spring容器：添加“@Component”注解，被Spring容器扫描为Bean实例；
 * 3、注册到执行器工厂：添加“@JobHandler(value="自定义jobhandler名称")”注解，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 * 4、执行日志：需要通过 "XxlJobLogger.log" 打印执行日志；
 */
@JobHandler(value = CommonConstant.HANDLER_NAME)
public class BeanByNameHandler extends IJobHandler implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    @Override
    public ReturnT<String> execute(String param) {
        XxlJobLogger.log(param);
        if (StringUtils.isBlank(param)) {
            return new ReturnT<>(ReturnT.FAIL_CODE, "参数不能为空！");
        }

        ExecutorParam executorParam = JSON.parseObject(param, ExecutorParam.class);
        if (StringUtils.isBlank(executorParam.getBeanName())) {
            return new ReturnT<>(ReturnT.FAIL_CODE, "参数格式错误，缺少bean名");
        }

        TaskCallback<?> callback;
        try {
            callback = applicationContext.getBean(executorParam.getBeanName(), TaskCallback.class);
        } catch (Exception e) {
            return new ReturnT<>(ReturnT.FAIL_CODE, "类" + executorParam.getBeanName() + "不存在");
        }

        return callback.execute(executorParam.getParams());
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
