/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.dubbo.spring;

import com.alibaba.dubbo.config.annotation.Service;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServiceBeanNameBuilder;
import org.apache.dubbo.config.spring.context.annotation.DubboClassPathBeanDefinitionScanner;
import org.apache.dubbo.config.spring.util.DubboAnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MockDubboServiceProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware,
ResourceLoaderAware,
BeanClassLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(MockDubboServiceProcessor.class);
    private ClassLoader classLoader;
    private Environment environment;
    private ResourceLoader resourceLoader;
    private static final List<Class<? extends Annotation>> serviceAnnotationTypes = Arrays.asList(DubboService.class, org.apache.dubbo.config.annotation.Service.class, Service.class);

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        DubboClassPathBeanDefinitionScanner scanner = new DubboClassPathBeanDefinitionScanner(registry, this.environment, this.resourceLoader);
        BeanNameGenerator beanNameGenerator = this.resolveBeanNameGenerator(registry);
        scanner.setBeanNameGenerator(beanNameGenerator);
        serviceAnnotationTypes.forEach(annotationType -> scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType)));
        Set<String> packagesToScan = this.resolvePackagesToScan();
        for (String packageToScan : packagesToScan) {
            scanner.scan(new String[]{packageToScan});
            Set<BeanDefinitionHolder> beanDefinitionHolders = this.findServiceBeanDefinitionHolders((ClassPathBeanDefinitionScanner)scanner, packageToScan, registry, beanNameGenerator);
            if (CollectionUtils.isEmpty(beanDefinitionHolders)) continue;
            for (BeanDefinitionHolder beanDefinitionHolder : beanDefinitionHolders) {
                this.registerServiceBean(beanDefinitionHolder, registry, scanner);
            }
        }
    }

    private void registerServiceBean(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry registry, DubboClassPathBeanDefinitionScanner scanner) {
        String beanName;
        Class<?> beanClass = this.resolveClass(beanDefinitionHolder);
        Annotation service = this.findServiceAnnotation(beanClass);
        AnnotationAttributes serviceAnnotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)service, (boolean)false, (boolean)false);
        Class interfaceClass = DubboAnnotationUtils.resolveServiceInterfaceClass((AnnotationAttributes)serviceAnnotationAttributes, beanClass);
        AbstractBeanDefinition serviceBeanDefinition = this.buildServiceBeanDefinition();
        Lazy lazyAnnotation = beanClass.getAnnotation(Lazy.class);
        if (lazyAnnotation != null) {
            serviceBeanDefinition.setLazyInit(lazyAnnotation.value());
        }
        if (scanner.checkCandidate(beanName = this.generateServiceBeanName(serviceAnnotationAttributes, interfaceClass), (BeanDefinition)serviceBeanDefinition)) {
            registry.registerBeanDefinition(beanName, (BeanDefinition)serviceBeanDefinition);
            if (!serviceBeanDefinition.getPropertyValues().contains("id")) {
                serviceBeanDefinition.getPropertyValues().addPropertyValue("id", (Object)beanName);
            }
        }
    }

    private String generateServiceBeanName(AnnotationAttributes serviceAnnotationAttributes, Class<?> interfaceClass) {
        ServiceBeanNameBuilder builder = ServiceBeanNameBuilder.create(interfaceClass, (Environment)this.environment).group(serviceAnnotationAttributes.getString("group")).version(serviceAnnotationAttributes.getString("version"));
        return builder.build();
    }

    private AbstractBeanDefinition buildServiceBeanDefinition() {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ServiceBean.class);
        return builder.getBeanDefinition();
    }

    private Annotation findServiceAnnotation(Class<?> beanClass) {
        return serviceAnnotationTypes.stream().map(annotationType -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanClass, (Class)annotationType)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Class<?> resolveClass(BeanDefinitionHolder beanDefinitionHolder) {
        BeanDefinition beanDefinition = beanDefinitionHolder.getBeanDefinition();
        return this.resolveClass(beanDefinition);
    }

    private Class<?> resolveClass(BeanDefinition beanDefinition) {
        String beanClassName = beanDefinition.getBeanClassName();
        return ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)this.classLoader);
    }

    private Set<BeanDefinitionHolder> findServiceBeanDefinitionHolders(ClassPathBeanDefinitionScanner scanner, String packageToScan, BeanDefinitionRegistry registry, BeanNameGenerator beanNameGenerator) {
        Set beanDefinitions = scanner.findCandidateComponents(packageToScan);
        LinkedHashSet<BeanDefinitionHolder> beanDefinitionHolders = new LinkedHashSet<BeanDefinitionHolder>(beanDefinitions.size());
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String beanName = beanNameGenerator.generateBeanName(beanDefinition, registry);
            BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(beanDefinition, beanName);
            beanDefinitionHolders.add(beanDefinitionHolder);
        }
        return beanDefinitionHolders;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private Set<String> resolvePackagesToScan() {
        HashSet<String> packagesToScan = new HashSet<String>();
        packagesToScan.add("com.bxm");
        LinkedHashSet<String> resolvedPackagesToScan = new LinkedHashSet<String>(packagesToScan.size());
        for (String packageToScan : packagesToScan) {
            if (!StringUtils.hasText((String)packageToScan)) continue;
            String resolvedPackageToScan = this.environment.resolvePlaceholders(packageToScan.trim());
            resolvedPackagesToScan.add(resolvedPackageToScan);
        }
        return resolvedPackagesToScan;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private BeanNameGenerator resolveBeanNameGenerator(BeanDefinitionRegistry registry) {
        AnnotationBeanNameGenerator beanNameGenerator = null;
        if (registry instanceof SingletonBeanRegistry) {
            SingletonBeanRegistry singletonBeanRegistry = (SingletonBeanRegistry)SingletonBeanRegistry.class.cast(registry);
            beanNameGenerator = (BeanNameGenerator)singletonBeanRegistry.getSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator");
        }
        if (beanNameGenerator == null) {
            if (log.isInfoEnabled()) {
                log.info("BeanNameGenerator bean can't be found in BeanFactory with name [org.springframework.context.annotation.internalConfigurationBeanNameGenerator]");
                log.info("BeanNameGenerator will be a instance of " + AnnotationBeanNameGenerator.class.getName() + " , it maybe a potential problem on bean name generation.");
            }
            beanNameGenerator = new AnnotationBeanNameGenerator();
        }
        return beanNameGenerator;
    }
}

