/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.spring;

import com.bxm.component.spring.event.ShutdownEvent;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ShutdownHook
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ShutdownHook.class);
    private ApplicationContext applicationContext;

    public ShutdownHook(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.registerShutdownHook();
    }

    private void registerShutdownHook() {
        log.info("\u6ce8\u518c\u81ea\u5b9a\u4e49 shutdown hook");
        try {
            Field shutdownHook = ReflectionUtils.findField(AbstractApplicationContext.class, (String)"shutdownHook");
            ReflectionUtils.makeAccessible((Field)shutdownHook);
            shutdownHook.set(this.applicationContext, this);
        }
        catch (IllegalAccessException e) {
            log.error("\u81ea\u5b9a\u4e49 shutdownHook \u5931\u8d25", (Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(this);
    }

    @Override
    public void run() {
        log.info("\u8fd0\u884c\u81ea\u5b9a\u4e49 shutdown hook");
        this.applicationContext.publishEvent((ApplicationEvent)new ShutdownEvent(this.applicationContext));
        log.info("\u8fd0\u884cspring shutdown hook");
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)this.applicationContext);
        ((ConfigurableApplicationContext)this.applicationContext).close();
    }
}

