/*
 * Decompiled with CFR 0.152.
 */
package com.bxm;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.ReflectionUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.multipart.MultipartFile;

@RunWith(value=SpringRunner.class)
@SpringBootTest
@ActiveProfiles(value={"LOCAL", "TEST"})
@AutoConfigureMockMvc
public class BaseTestSupporter {
    @Autowired
    public WebApplicationContext webApplicationContext;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected MockMvc mockMvc;
    private ServletContext servletContext;

    @Before
    public void setUp() {
        this.servletContext = this.webApplicationContext.getServletContext();
    }

    protected <Z> Z getJson(MvcResult result, Class<Z> clasz) {
        try {
            return (Z)JSON.parseObject((String)result.getResponse().getContentAsString(), clasz);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected <Z> Z getJson(MockHttpServletRequestBuilder requestBuilder, Class<Z> clasz) {
        return this.getJson(this.perform(requestBuilder).andReturn(), clasz);
    }

    protected ResponseJson getJson(MockHttpServletRequestBuilder requestBuilder) {
        return this.getJson(this.perform(requestBuilder).andReturn(), ResponseJson.class);
    }

    protected ResultActions perform(MockHttpServletRequestBuilder request) {
        try {
            return this.mockMvc.perform((RequestBuilder)request);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected <Z> ResponseJson<Z> getJson(MockHttpServletRequestBuilder requestBuilder, TypeReference<ResponseJson<Z>> typeReference) {
        return this.getJson(this.perform(requestBuilder).andReturn(), typeReference);
    }

    protected <Z> ResponseJson<Z> getJson(MvcResult result, TypeReference<ResponseJson<Z>> typeReference) {
        try {
            return (ResponseJson)JSON.parseObject((String)result.getResponse().getContentAsString(), typeReference);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected <T> void assertResponseOk(ResponseJson<T> result) {
        Assert.assertTrue((result.getCode() == HttpStatus.OK.value() ? 1 : 0) != 0);
    }

    protected <T> void buildRequest(MockHttpServletRequestBuilder request, T paramObj) {
        this.deepObjBuild(request, null, 0, paramObj);
    }

    protected void buildPostReqeust(MockHttpServletRequestBuilder request, Object param) {
        request.contentType(MediaType.APPLICATION_JSON_UTF8);
        request.content(JSON.toJSONString((Object)param));
    }

    private void buildArray(MockHttpServletRequestBuilder request, String fieldName, Object array) {
        if (Collection.class.isAssignableFrom(array.getClass())) {
            Collection collectionObj = (Collection)array;
            int index = 0;
            for (Object element : collectionObj) {
                this.deepObjBuild(request, fieldName, index, element);
                ++index;
            }
        }
    }

    private void deepObjBuild(MockHttpServletRequestBuilder request, String parentFieldName, int index, Object childObj) {
        Method[] allDeclaredMethods;
        for (Method declaredMethod : allDeclaredMethods = org.springframework.util.ReflectionUtils.getAllDeclaredMethods(childObj.getClass())) {
            Object value;
            String fieldName;
            Class<?> returnType = declaredMethod.getReturnType();
            if (Void.TYPE.isAssignableFrom(returnType) || (fieldName = ReflectionUtils.getFieldName((String)declaredMethod.getName())) == null || null == (value = org.springframework.util.ReflectionUtils.invokeMethod((Method)declaredMethod, (Object)childObj))) continue;
            if (null != parentFieldName) {
                fieldName = parentFieldName + "[" + index + "]." + fieldName;
            }
            if (MultipartFile.class.isAssignableFrom(returnType)) {
                if (request instanceof MockMultipartHttpServletRequestBuilder) {
                    ((MockMultipartHttpServletRequestBuilder)request).file((MockMultipartFile)value);
                    continue;
                }
                this.logger.error("\u8bbe\u7f6e\u7684\u5bf9\u8c61\u5305\u542b\u6587\u4ef6\uff0c\u4f46\u662f\u8bf7\u6c42\u4e0d\u662fMockMultipartHttpServletRequestBuilder\u7684\u5b9e\u4f8b\uff0c\u4f7f\u7528MockMvcRequestBuilders.multipart\u6784\u5efa\u7b26\u5408\u6761\u4ef6\u7684\u5b9e\u4f8b");
                continue;
            }
            if (Date.class.isAssignableFrom(returnType)) {
                request.param(fieldName, new String[]{DateUtils.formatDateTime((Date)((Date)value))});
                continue;
            }
            if (BigDecimal.class.isAssignableFrom(returnType)) {
                request.param(fieldName, new String[]{value.toString()});
                continue;
            }
            if (ReflectionUtils.isPrimitiveType(returnType)) {
                request.param(fieldName, new String[]{value.toString()});
                continue;
            }
            if (Collection.class.isAssignableFrom(returnType)) {
                this.buildArray(request, fieldName, value);
                continue;
            }
            if (Class.class.isAssignableFrom(returnType)) continue;
            this.logger.info("\u5ffd\u7565\u5c5e\u6027\u503c[{}],\u5176\u5bf9\u8c61\u7c7b\u578b\u662f[{}]", (Object)fieldName, returnType);
        }
    }

    protected MockMultipartFile createMockFile(String filePath, String fieldName) {
        String finalFilePath = FileUtils.getClassRootPath() + File.separator + filePath;
        String fileName = FileUtils.getFileName((String)filePath);
        MockMultipartFile mockFile = null;
        try {
            String contextType = FileTypeEnum.getContentType((String)FileUtils.getFilextension((String)fileName));
            mockFile = new MockMultipartFile(fieldName, fileName, contextType, (InputStream)org.apache.commons.io.FileUtils.openInputStream((File)new File(finalFilePath)));
        }
        catch (IOException e) {
            this.logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728:" + finalFilePath, (Throwable)e);
        }
        return mockFile;
    }
}

