package com.bxm.newidea.component.filter;

import org.springframework.core.Ordered;

/**
 * spring环境内的过滤器，会将所有的过滤器全部执行一遍
 * 用于进行业务流程的过滤处理
 * 可用于过滤器的场景和责任链的场景
 *
 * @author liujia
 * @date 1/13/21 5:56 PM
 **/
public interface IFilter<T> extends Ordered {

    /**
     * 执行过滤操作
     *
     * @param context 过滤器的上下文
     */
    void doFilter(T context);

    /**
     * 过滤器是否支持并行处理，如果涉及到相同资源的过滤器，返回false，可以额外线型执行
     * 如果同时存在并行过滤器和非并行过滤器，则优先执行并行过滤器，然后根据order，执行非并行过滤器
     *
     * @return true表示支持并行
     */
    default boolean supportParallel() {
        return true;
    }
}
