/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.strategy;

import com.bxm.newidea.component.annotations.StrategyBean;
import com.bxm.newidea.component.strategy.IReturnedStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class ReturnedStrategyExecutor
implements ApplicationRunner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ReturnedStrategyExecutor.class);
    private Map<String, List<IReturnedStrategy>> groupStrategyMap = new HashMap<String, List<IReturnedStrategy>>();
    private ApplicationContext applicationContext;

    public <T, P> T execute(String groupName, P param) {
        List<IReturnedStrategy> strategies = this.groupStrategyMap.get(groupName);
        if (null == strategies) {
            log.error("\u4e0d\u5b58\u5728[{}]\u5bf9\u5e94\u7684\u7b56\u7565\u903b\u8f91\u5206\u7ec4", (Object)groupName);
            return null;
        }
        for (IReturnedStrategy strategy : strategies) {
            if (!strategy.match(param)) continue;
            return strategy.execute(param);
        }
        log.info("[{}][{}]\u6ca1\u6709\u5339\u914d\u5230\u4efb\u4f55\u7b56\u7565", (Object)groupName, param);
        return null;
    }

    public <T, P> T execute(String groupName, String strategyName, P param) {
        List<IReturnedStrategy> strategies = this.groupStrategyMap.get(groupName);
        if (null == strategies) {
            log.error("\u4e0d\u5b58\u5728[{}]\u5bf9\u5e94\u7684\u7b56\u7565\u903b\u8f91\u5206\u7ec4", (Object)groupName);
            return null;
        }
        for (IReturnedStrategy strategy : strategies) {
            boolean match = strategyName != null && strategyName.equalsIgnoreCase(strategy.name()) || strategy.match(param);
            if (!match) continue;
            return strategy.execute(param);
        }
        log.info("[{}]-[{}]-[{}]\u6ca1\u6709\u5339\u914d\u5230\u4efb\u4f55\u7b56\u7565", new Object[]{groupName, strategyName, param});
        return null;
    }

    public void run(ApplicationArguments args) {
        for (IReturnedStrategy iReturnedStrategy : this.applicationContext.getBeansOfType(IReturnedStrategy.class).values()) {
            StrategyBean annotation = (StrategyBean)AnnotationUtils.findAnnotation(iReturnedStrategy.getClass(), StrategyBean.class);
            if (null == annotation) {
                log.warn("[{}]\u672a\u63d0\u4f9bStrategyBean\u6ce8\u89e3", (Object)iReturnedStrategy.getClass().getSimpleName());
                continue;
            }
            List<IReturnedStrategy> strategies = this.groupStrategyMap.get(annotation.group());
            if (strategies == null) {
                strategies = new ArrayList<IReturnedStrategy>();
            }
            strategies.add(iReturnedStrategy);
            this.groupStrategyMap.put(annotation.group(), strategies);
        }
        for (List list : this.groupStrategyMap.values()) {
            OrderComparator.sort((List)list);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

