package com.bxm.newidea.component.strategy;

import org.springframework.core.Ordered;

/**
 * 有返回值的策略实现
 *
 * @author liujia
 * @date 6/4/21 6:45 PM
 **/
public interface IReturnedStrategy<T, P> extends Ordered {

    /**
     * 执行策略逻辑
     *
     * @param param 请求参数
     * @return 执行结果
     */
    T execute(P param);

    /**
     * 策略名称
     *
     * @return 策略名称，可用于匹配策略
     */
    default String name() {
        return null;
    }

    /**
     * 通过参数进行匹配
     *
     * @param param 参数类
     * @return true表示匹配当前策略
     */
    default boolean match(P param) {
        return false;
    }

    @Override
    default int getOrder() {
        // 默认不需要设置排序，如果出现多个相同的策略，可以通过顺序控制
        return 0;
    }
}
