/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.filter;

import com.bxm.newidea.component.annotations.LogicFilterBean;
import com.bxm.newidea.component.exception.ExcutorException;
import com.bxm.newidea.component.filter.ILogicFilter;
import com.bxm.newidea.component.filter.LogicFilterChain;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class LogicFilterChainExecutor
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(LogicFilterChainExecutor.class);
    private Map<String, List<ILogicFilter>> groupFilterMap = new HashMap<String, List<ILogicFilter>>();

    public <T> void doFilter(String group, T context) {
        List<ILogicFilter> filters = this.groupFilterMap.get(group);
        if (null == filters) {
            return;
        }
        try {
            LogicFilterChain<T> filterChain = new LogicFilterChain<T>(filters);
            filterChain.filter(context);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExcutorException("\u8fc7\u6ee4\u5668\u6267\u884c\u5931\u8d25,\u7b56\u7565\u5206\u7ec4\uff1a" + group, e);
        }
    }

    public void run(ApplicationArguments args) {
        for (ILogicFilter iLogicFilter : SpringContextHolder.getBeans(ILogicFilter.class)) {
            LogicFilterBean annotation = (LogicFilterBean)AnnotationUtils.findAnnotation(iLogicFilter.getClass(), LogicFilterBean.class);
            if (null == annotation) {
                log.warn("[{}]\u672a\u63d0\u4f9bFilterBean\u6ce8\u89e3", (Object)iLogicFilter.getClass().getSimpleName());
                continue;
            }
            List<ILogicFilter> filters = this.groupFilterMap.get(annotation.group());
            if (filters == null) {
                filters = new ArrayList<ILogicFilter>();
            }
            filters.add(iLogicFilter);
            this.groupFilterMap.put(annotation.group(), filters);
        }
        for (List list : this.groupFilterMap.values()) {
            OrderComparator.sort((List)list);
        }
    }
}

