package com.bxm.component.tbk.order.model.dto;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

@Data
@Builder
public class CommissionPlatformFacadeDTO {

    @Tolerate
    public CommissionPlatformFacadeDTO() {
    }

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * vip 自购佣金金额
     */
    private BigDecimal vipPurchasePrice;

    /**
     * 自购佣金金额
     */
    private BigDecimal purchasePrice;

    /**
     * 上级佣金金额
     */
    private BigDecimal parentPrice;

    /**
     * 上上级佣金金额
     */
    private BigDecimal grandParentPrice;

    /**
     * 佣金比例信息
     */
    private PlatformCommissionRageConfigInfo platformCommissionRageConfigInfo;

    /**
     * 佣金的类型
     * @see CommissionType
     */
    private Byte commissionType;
}
