package com.bxm.component.tbk.order.model.dto;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 淘宝客拉取订单的返回数据对象
 * @author Gonzo
 * @date  2020-05-02 10:48
 * @since 2.0.0
 */
@Data
@Builder
public class TbkOrderInfo {

    @Tolerate
    public TbkOrderInfo() {
    }

    /**
     * 商品ID
     */
    private String goodsId;

    /**
     * 商品标题
     */
    private String goodsName;

    /**
     * 用户渠道ID
     */
    private String  relationId;

    /**
     * 用户会员ID
     */
    private String specialId;

    /**
     * 来源（目前淘宝）订单号 （标识不同产品，每个产品一个子订单号，可做为一比订单的唯一标识）
     */
    private String orderSn;

    /**
     * 来源（目前淘宝）父订单号 （相同产品不同规格的统一标识）
     */
    private String orderParentSn;

    /**
     * 订单返回的产品价格
     */
    private BigDecimal goodsPrice;

    /**
     * 实际支付价格
     */
    private BigDecimal payPrice;

    /**
     * 商品购买数量
     */
    private Long goodsNum;

    /**
     * 来源（目前淘宝）订单创建时间
     */
    private Date sourceOrderCreateTime;

    /**
     * 来源（目前淘宝）订单结算时间
     */
    private Date sourceOrderEarningTime;

    /**
     * 订单状态  0：待结算   1：已结算   2：失效
     */
    private int orderStatus;

    /**
     * 来源（目前淘宝）订单状态 3：订单结算，12：订单付款， 13：订单失效，14：订单成功
     */
    private int sourceOwnerOrderStatus;

    /**
     * 佣金 / 元
     */
    private BigDecimal commission;

    /**
     * VIP自购返比例
     */
    private BigDecimal vipPurchaseCommission;

    /**
     * 自购返现比例
     */
    private BigDecimal purchaseCommission;

    /**
     * 上级返现比例
     */
    private BigDecimal parentCommission;

    /**
     * 上上级返现比例
     */
    private BigDecimal grandparentCommission;

    /**
     * 来源  TB:淘宝
     */
    private String source;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 商品首图
     */
    private String imgUrl;

    /**
     * pid
     */
    private String pid;

    /**
     * 场景订单场景类型，1:常规订单，2:渠道订单，3:会员运营订单
     */
    private int type;

    /**
     * 淘宝订单类型
     */
    private String tbOrderType;

    /**
     * 商品优惠券
     */
    private BigDecimal coupon;

    /**
     * 源数据字符串
     */
    private String sourceStr;
}
