package com.bxm.component.tbk.order.timer;


import com.bxm.component.tbk.order.config.OrderTimerConfigProperties;
import com.bxm.component.tbk.order.service.OrderRefundService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 维权订单查询定时任务
 *
 * @author Gonzo
 * @date 2020-04-23 21:33
 * @since 1.7.0
 */

@Slf4j
@Component
@AllArgsConstructor
public class OrderRefundTask extends AbstractCronTask<String> {

    private final OrderRefundService orderRefundService;

    private final OrderTimerConfigProperties orderTimerConfigProperties;

    @Override
    protected ReturnT<String> service(String s) {

        log.info("执行任务: {} 开始", taskName());
        try {
            orderRefundService.pullRefundOrderDays();
            log.info("执行任务: {} 结束", taskName());

        } catch (Exception e) {
            log.error("执行任务: {} 失败", taskName(), e);
            return ReturnT.FAIL;
        }

        return ReturnT.SUCCESS;
    }


    @Override
    public String taskName() {
        return "每日维权订单查询定时任务";
    }

    @Override
    public String cron() {
        if (log.isDebugEnabled()) {
            log.debug("{}: {}", taskName(), orderTimerConfigProperties.getOrderRefundCron());
        }

        return orderTimerConfigProperties.getOrderRefundCron();
    }
}
