package com.bxm.component.tbk.order.service.impl;

import com.bxm.component.tbk.order.service.OrderCommissionSettleService;
import lombok.extern.slf4j.Slf4j;

/**
 * 订单结算
 * @author Gonzo
 * @date  2020-05-03 14:42
 * @since 2.0.0
 */
@Slf4j
public abstract class AbstractOrderCommissionSettleService implements OrderCommissionSettleService {

    /**
     * 每月佣金结算
     */
    @Override
    public void payCashForLastMonthOrder() {
        try {
            doPayCashForLastMonthOrder();
        } catch(Exception e) {
            log.error("处理每月佣金结算失败", e);
        }
    }

    /**
     * 每月购物订单佣金结算
     */
    protected abstract void doPayCashForLastMonthOrder();

}
