/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.tbk.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.tbk.order.api.MeituanOrderApi;
import com.bxm.component.tbk.order.config.DuoMaiMeituanProperties;
import com.bxm.component.tbk.order.model.dto.MeituanOrderInfo;
import com.bxm.component.tbk.order.model.dto.MeituanOrderSourceInfo;
import com.bxm.component.tbk.order.model.param.QueryMeituanOrderListParam;
import com.bxm.component.tbk.order.service.MeituanTakeOutOrderService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractMeituanTakeOutOrderService
implements MeituanTakeOutOrderService {
    private static final Logger log = LoggerFactory.getLogger(AbstractMeituanTakeOutOrderService.class);
    @Autowired
    private MeituanOrderApi meituanOrderApi;
    @Autowired
    private DuoMaiMeituanProperties duoMaiMeituanProperties;

    @Override
    public Integer orderNotice(MeituanOrderSourceInfo orderInfo) {
        String orderInfoStr = JSON.toJSONString((Object)orderInfo);
        log.info("\u591a\u9ea6\u56de\u8c03\u4fe1\u606f: {}", (Object)orderInfoStr);
        return this.syncOrderInfo((MeituanOrderInfo)JSON.parseObject((String)orderInfoStr, MeituanOrderInfo.class));
    }

    @Override
    public void syncOrderOneDayOnce() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime start = now.minusDays(this.duoMaiMeituanProperties.getSyncCreateOrderBeforeDays().intValue());
        start = LocalDateTime.of(start.getYear(), start.getMonth(), start.getDayOfMonth(), 0, 0, 0, 0);
        LocalDateTime end = now.minusDays(1L);
        end = LocalDateTime.of(end.getYear(), end.getMonth(), end.getDayOfMonth(), 23, 59, 59, 999);
        this.syncOrder(start, end, null, null);
    }

    @Override
    public void syncOrder(LocalDateTime timeFrom, LocalDateTime timeTo, LocalDateTime chargeFrom, LocalDateTime chargeTo) {
        log.info("\u67e5\u8be2\u7f8e\u56e2\u8ba2\u5355\uff0c timeFrom: {}, timeTo: {}, chargeFrom: {}, chargeTo: {}", new Object[]{timeFrom, timeTo, chargeFrom, chargeTo});
        if (Objects.isNull(timeFrom) && Objects.isNull(timeTo) && Objects.isNull(chargeFrom) && Objects.isNull(chargeTo)) {
            log.warn("\u67e5\u8be2\u7f8e\u56e2\u8ba2\u5355 \u6ca1\u6709\u6307\u5b9a\u67e5\u8be2\u65f6\u95f4");
            return;
        }
        int pageNo = 0;
        while (true) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            QueryMeituanOrderListParam param = new QueryMeituanOrderListParam();
            if (Objects.nonNull(timeFrom) && Objects.nonNull(timeTo)) {
                param.setTimeFrom(timeFrom.format(formatter));
                param.setTimeTo(timeTo.format(formatter));
            }
            if (Objects.nonNull(chargeFrom) && Objects.nonNull(chargeTo)) {
                param.setChargeFrom(chargeFrom.format(formatter));
                param.setChargeTo(chargeTo.format(formatter));
            }
            param.setLimit(StringUtils.join((Object[])new Serializable[]{Integer.valueOf(pageNo++), ",", this.duoMaiMeituanProperties.getPageSize()}));
            param.setFormat(this.duoMaiMeituanProperties.getFormat());
            List<MeituanOrderInfo> meituanOrderInfos = this.meituanOrderApi.queryList(param);
            if (CollectionUtils.isEmpty(meituanOrderInfos)) break;
            meituanOrderInfos.forEach(this::syncOrderInfo);
        }
    }

    private Integer syncOrderInfo(MeituanOrderInfo orderInfo) {
        log.info("\u5904\u7406\u7f8e\u56e2\u8ba2\u5355\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)orderInfo));
        try {
            return this.doSyncOrderInfo(orderInfo);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u7f8e\u56e2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25 \u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)orderInfo), (Object)e);
            return -1;
        }
    }

    protected abstract Integer doSyncOrderInfo(MeituanOrderInfo var1);
}

