/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.tbk.order.timer;

import com.bxm.component.tbk.order.config.OrderTimerConfigProperties;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.model.enums.TakeOutOrderSource;
import com.bxm.component.tbk.order.service.EleTakeOutOrderService;
import com.bxm.component.tbk.order.service.TakeOutOrderCommissionService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EleOrderStatusSyncAndCommissionSettleDaysTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(EleOrderStatusSyncAndCommissionSettleDaysTask.class);
    private final EleTakeOutOrderService eleTakeOutOrderService;
    private final TakeOutOrderCommissionService takeOutOrderCommissionSettleService;
    private final OrderTimerConfigProperties orderTimerConfigProperties;
    private final TbkOpenOrderProperties tbkOpenOrderProperties;

    protected ReturnT<String> service(String s) {
        log.info("\u6267\u884c\u4efb\u52a1: {} \u5f00\u59cb", (Object)this.taskName());
        try {
            this.eleTakeOutOrderService.syncOrderStatusDays();
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            this.takeOutOrderCommissionSettleService.commissionSettleByOrderTypeAndTimeBefore(TakeOutOrderSource.ELE, DateUtils.getDayEndTime((Date)calendar.getTime()));
            log.info("\u6267\u884c\u4efb\u52a1: {} \u7ed3\u675f", (Object)this.taskName());
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u4efb\u52a1: {} \u5931\u8d25", (Object)this.taskName(), (Object)e);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "\u6bcf\u65e5\u997f\u4e86\u4e48\u8ba2\u5355\u72b6\u6001\u540c\u6b65\u548c\u4f63\u91d1\u7ed3\u7b97_" + this.tbkOpenOrderProperties.getSite();
    }

    public String cron() {
        if (log.isDebugEnabled()) {
            log.debug("{}: {}", (Object)this.taskName(), (Object)this.orderTimerConfigProperties.getEleOrderStatusSyncAndCommissionSettleDaysCron());
        }
        return this.orderTimerConfigProperties.getEleOrderStatusSyncAndCommissionSettleDaysCron();
    }

    public EleOrderStatusSyncAndCommissionSettleDaysTask(EleTakeOutOrderService eleTakeOutOrderService, TakeOutOrderCommissionService takeOutOrderCommissionSettleService, OrderTimerConfigProperties orderTimerConfigProperties, TbkOpenOrderProperties tbkOpenOrderProperties) {
        this.eleTakeOutOrderService = eleTakeOutOrderService;
        this.takeOutOrderCommissionSettleService = takeOutOrderCommissionSettleService;
        this.orderTimerConfigProperties = orderTimerConfigProperties;
        this.tbkOpenOrderProperties = tbkOpenOrderProperties;
    }
}

