package com.bxm.component.tbk.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 淘宝客配置
 * @author Gonzo
 * @date  2020-05-29 10:10
 * @since 1.0.0
 */
@Component
@ConfigurationProperties("tbk.config")
@Data
public class TbkConfigProperties {

    /**
     * 淘宝开放平台的请求地址
     * 正式环境 http://gw.api.taobao.com/router/rest
     *  带https https://eco.taobao.com/router/rest
     * 沙箱环境 http://gw.api.tbsandbox.com/router/rest
     *  带https https://gw.api.tbsandbox.com/router/rest
     */
    private String tbOpenUrl = "https://eco.taobao.com/router/rest";

    /**
     * 不同站点对应的淘宝客app key配置信息
     * map key {@link com.bxm.newidea.component.enums.AppNameEnum}
     */
    private Map<String, String> tbkAppKeyConfigMap;

    /**
     * 不同站点对应的淘宝客app secret配置信息
     * map key {@link com.bxm.newidea.component.enums.AppNameEnum}
     */
    private Map<String, String> tbkAppSecretConfigMap;

}
