package com.bxm.component.test.spring;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

/**
 * @author Gonzo
 * @date 2019-11-11 17:33
 */
public class FeignClientsRegistrar implements ImportBeanDefinitionRegistrar {


    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {

        AnnotationAttributes attributes = AnnotationAttributes.fromMap(importingClassMetadata
                .getAnnotationAttributes(FeignClient.class.getName()));


        BeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(FeignFactoryBean.class).getBeanDefinition();

        registry.registerBeanDefinition(FeignFactoryBean.class.getName(), beanDefinition);

    }
}
