/*
 * Decompiled with CFR 0.152.
 */
package org.thunlp.thulac.postprocess;

import java.io.IOException;
import java.util.List;
import org.thunlp.thulac.data.Dat;
import org.thunlp.thulac.data.TaggedWord;
import org.thunlp.thulac.postprocess.IPostprocessPass;

public class VerbPass
implements IPostprocessPass {
    private Dat vM;
    private Dat vD;
    private String tag;

    public VerbPass(String vMFile, String vDFile) throws IOException {
        this.vM = new Dat(vMFile);
        this.vD = new Dat(vDFile);
        this.tag = "v";
    }

    @Override
    public void process(List<TaggedWord> sentence) {
        if (this.vM == null || this.vD == null || sentence.isEmpty()) {
            return;
        }
        TaggedWord last = sentence.get(0);
        int size = sentence.size();
        for (int i = 1; i < size; ++i) {
            TaggedWord tagged = sentence.get(i + 1);
            if (this.tag.equals(last.tag) && this.tag.equals(tagged.tag)) {
                if (this.vM.contains(last.word)) {
                    tagged.tag = "vm";
                } else if (this.vD.contains(tagged.word)) {
                    tagged.tag = "vd";
                }
            }
            last = tagged;
        }
    }
}

